/*
 * Decompiled with CFR 0.152.
 */
package moa.classifiers.meta;

import com.github.javacliparser.FloatOption;
import com.github.javacliparser.IntOption;
import com.yahoo.labs.samoa.instances.Instance;
import moa.classifiers.AbstractClassifier;
import moa.classifiers.Classifier;
import moa.classifiers.MultiClassClassifier;
import moa.core.DoubleVector;
import moa.core.Measurement;
import moa.options.ClassOption;

public class OnlineSmoothBoost
extends AbstractClassifier
implements MultiClassClassifier {
    private static final long serialVersionUID = 1L;
    public ClassOption baseLearnerOption = new ClassOption("baseLearner", 'l', "Classifier to train.", Classifier.class, "trees.HoeffdingTree");
    public IntOption ensembleSizeOption = new IntOption("ensembleSize", 's', "The number of models to boost.", 10, 1, Integer.MAX_VALUE);
    public FloatOption gammaOption = new FloatOption("gamma", 'g', "The value of the gamma parameter.", 0.1, 0.0, 1.0);
    protected Classifier[] ensemble;
    protected double[] alpha;
    protected double gamma;
    protected double theta;

    @Override
    public String getPurposeString() {
        return "Incremental on-line boosting of Shang-Tse Chen, Hsuan-Tien Lin and Chi-Jen Lu.";
    }

    @Override
    public void resetLearningImpl() {
        this.ensemble = new Classifier[this.ensembleSizeOption.getValue()];
        Classifier baseLearner = (Classifier)this.getPreparedClassOption(this.baseLearnerOption);
        baseLearner.resetLearning();
        this.alpha = new double[this.ensemble.length];
        for (int i = 0; i < this.ensemble.length; ++i) {
            this.ensemble[i] = baseLearner.copy();
            this.alpha[i] = 1.0 / (double)this.ensemble.length;
        }
        this.gamma = this.gammaOption.getValue();
        this.theta = this.gamma / (2.0 + this.gamma);
    }

    @Override
    public void trainOnInstanceImpl(Instance inst) {
        double zt = 0.0;
        double weight = 1.0;
        for (int i = 0; i < this.ensemble.length; ++i) {
            int n = this.ensemble[i].correctlyClassifies(inst) ? 1 : -1;
            Instance weightedInst = inst.copy();
            weightedInst.setWeight(weight);
            this.ensemble[i].trainOnInstance(weightedInst);
            weight = zt <= 0.0 ? 1.0 : Math.pow(1.0 - this.gamma, (zt += (double)n - this.theta) / 2.0);
        }
    }

    protected double getEnsembleMemberWeight(int i) {
        return this.alpha[i];
    }

    @Override
    public double[] getVotesForInstance(Instance inst) {
        double memberWeight;
        DoubleVector combinedVote = new DoubleVector();
        for (int i = 0; i < this.ensemble.length && (memberWeight = this.getEnsembleMemberWeight(i)) > 0.0; ++i) {
            DoubleVector vote = new DoubleVector(this.ensemble[i].getVotesForInstance(inst));
            if (!(vote.sumOfValues() > 0.0)) continue;
            vote.normalize();
            vote.scaleValues(memberWeight);
            combinedVote.addValues(vote);
        }
        return combinedVote.getArrayRef();
    }

    @Override
    public boolean isRandomizable() {
        return true;
    }

    @Override
    public void getModelDescription(StringBuilder out, int indent) {
    }

    @Override
    protected Measurement[] getModelMeasurementsImpl() {
        return new Measurement[]{new Measurement("ensemble size", this.ensemble != null ? (double)this.ensemble.length : 0.0)};
    }

    @Override
    public Classifier[] getSubClassifiers() {
        return (Classifier[])this.ensemble.clone();
    }
}

