/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.data;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.vikamine.kernel.data.DataRecord;
import org.vikamine.kernel.data.DefaultAttribute;
import org.vikamine.kernel.data.IDataRecordSet;
import org.vikamine.kernel.data.SingleValue;
import org.vikamine.kernel.data.Value;
import org.vikamine.kernel.util.DistinctionFinder;
import org.vikamine.kernel.util.VKMUtil;

public class NumericAttribute
extends DefaultAttribute {
    static final String ARFF_ATTRIBUTE_NUMERIC_IDENTIFIER = "numeric";
    protected BitSet usedInstancesForAttributeValues;
    protected WeakReference<IDataRecordSet> weakDatasetReference;

    protected NumericAttribute(String id) {
        super(id);
    }

    @Override
    public NumericAttribute copy() {
        NumericAttribute copiedNumericAttribute = new NumericAttribute(this.getId());
        copiedNumericAttribute.usedInstancesForAttributeValues = this.usedInstancesForAttributeValues;
        copiedNumericAttribute.weakDatasetReference = this.weakDatasetReference;
        return copiedNumericAttribute;
    }

    private void createUsedInstancesForAttributeValues() {
        this.usedInstancesForAttributeValues = new BitSet();
        ArrayList sortedInstances = new ArrayList();
        this.usedInstancesForAttributeValues.set(0, ((IDataRecordSet)this.weakDatasetReference.get()).getNumInstances(), true);
        Collections.sort(sortedInstances, new Comparator<Integer>(){

            @Override
            public int compare(Integer i1, Integer i2) {
                DataRecord inst1 = ((IDataRecordSet)NumericAttribute.this.weakDatasetReference.get()).get(i1);
                DataRecord inst2 = ((IDataRecordSet)NumericAttribute.this.weakDatasetReference.get()).get(i2);
                return Double.compare(inst1.getValue(NumericAttribute.this), inst2.getValue(NumericAttribute.this));
            }
        });
        DistinctionFinder distinct = new DistinctionFinder();
        int previous = 0;
        Iterator iter = sortedInstances.iterator();
        while (iter.hasNext()) {
            int i = (Integer)iter.next();
            DataRecord inst = ((IDataRecordSet)this.weakDatasetReference.get()).get(i);
            distinct.addValue(inst.getValue(this));
            if (distinct.isNewValue()) {
                this.usedInstancesForAttributeValues.set(previous);
            }
            previous = i;
        }
        this.usedInstancesForAttributeValues.set(previous);
    }

    @Override
    public double getValue(DataRecord instance) {
        return instance.getValue(instance.getDataset().getIndex(this));
    }

    public int getUsedValuesCount(IDataRecordSet dataset) {
        HashSet<Double> allUsedValues = new HashSet<Double>();
        for (DataRecord dr : dataset) {
            allUsedValues.add(this.getValue(dr));
        }
        return allUsedValues.size();
    }

    @Override
    public boolean isMissingValue(DataRecord record) {
        return Value.isMissingValue(record.getValue(this));
    }

    @Override
    public boolean isNumeric() {
        return true;
    }

    public String toString() {
        StringBuffer text = new StringBuffer();
        text.append("@attribute").append(" ").append(VKMUtil.quote(this.getId())).append(" ");
        text.append(ARFF_ATTRIBUTE_NUMERIC_IDENTIFIER);
        return text.toString();
    }

    @Override
    public Iterator<Value> usedValuesIterator(IDataRecordSet dataset) {
        if (this.usedInstancesForAttributeValues == null || this.weakDatasetReference == null || !((IDataRecordSet)this.weakDatasetReference.get()).equals(dataset)) {
            this.weakDatasetReference = new WeakReference<IDataRecordSet>(dataset);
            this.createUsedInstancesForAttributeValues();
        }
        return new NumericIterator();
    }

    public Value getNumericValue(double value) {
        return SingleValue.createSimpleSingleValue(this, value, VKMUtil.getFormattedDoubleString(value));
    }

    private class NumericIterator
    implements Iterator<Value> {
        int currentBit = -1;

        NumericIterator() {
            this.nextBit();
        }

        @Override
        public boolean hasNext() {
            return this.currentBit != -1 && this.currentBit < NumericAttribute.this.usedInstancesForAttributeValues.size();
        }

        @Override
        public SingleValue next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("no more elements");
            }
            DataRecord inst = ((IDataRecordSet)NumericAttribute.this.weakDatasetReference.get()).get(this.currentBit);
            this.nextBit();
            double value = inst.getValue(NumericAttribute.this);
            return SingleValue.createSimpleSingleValue(NumericAttribute.this, value, VKMUtil.getFormattedDoubleString(value));
        }

        private void nextBit() {
            do {
                ++this.currentBit;
            } while (!NumericAttribute.this.usedInstancesForAttributeValues.get(this.currentBit) && this.currentBit < NumericAttribute.this.usedInstancesForAttributeValues.size());
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported");
        }
    }
}

