/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.ssf.sts;

import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.ssf.ISsfDynamics;
import jdplus.toolkit.base.core.ssf.ISsfInitialization;
import jdplus.toolkit.base.core.ssf.ISsfLoading;
import jdplus.toolkit.base.core.ssf.StateComponent;
import jdplus.toolkit.base.core.ssf.basic.Loading;
import lombok.Generated;

public final class Noise {
    public static int dim() {
        return 1;
    }

    public static StateComponent of(double var) {
        return new StateComponent(new Initialization(var), new Dynamics(var));
    }

    public static ISsfLoading defaultLoading() {
        return Loading.fromPosition(0);
    }

    public static ISsfLoading periodicLoading(int period, int startPos) {
        return Loading.circular(period, startPos);
    }

    @Generated
    private Noise() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static class Initialization
    implements ISsfInitialization {
        private final double var;

        Initialization(double var) {
            this.var = var;
        }

        @Override
        public int getStateDim() {
            return 1;
        }

        @Override
        public boolean isDiffuse() {
            return false;
        }

        @Override
        public int getDiffuseDim() {
            return 0;
        }

        @Override
        public void diffuseConstraints(FastMatrix b) {
        }

        @Override
        public void a0(DataBlock a0) {
        }

        @Override
        public void Pf0(FastMatrix pf0) {
            pf0.set(0, 0, this.var);
        }
    }

    static class Dynamics
    implements ISsfDynamics {
        private final double var;
        private final double e;

        Dynamics(double var) {
            this.var = var;
            this.e = Math.sqrt(var);
        }

        @Override
        public int getInnovationsDim() {
            return 1;
        }

        @Override
        public void V(int pos, FastMatrix qm) {
            qm.set(0, 0, this.var);
        }

        @Override
        public void S(int pos, FastMatrix cm) {
            cm.set(0, 0, this.e);
        }

        @Override
        public boolean hasInnovations(int pos) {
            return true;
        }

        @Override
        public boolean areInnovationsTimeInvariant() {
            return true;
        }

        @Override
        public void T(int pos, FastMatrix tr) {
        }

        @Override
        public void TX(int pos, DataBlock x) {
            x.set(0.0);
        }

        @Override
        public void TVT(int pos, FastMatrix v) {
            v.set(0, 0, 0.0);
        }

        @Override
        public void addSU(int pos, DataBlock x, DataBlock u) {
            x.add(0, this.e * u.get(0));
        }

        @Override
        public void addV(int pos, FastMatrix p) {
            p.add(0, 0, this.var);
        }

        @Override
        public void XT(int pos, DataBlock x) {
            x.set(0, 0.0);
        }

        @Override
        public void XS(int pos, DataBlock x, DataBlock xs) {
            xs.set(0, x.get(0) * this.e);
        }

        @Override
        public boolean isTimeInvariant() {
            return true;
        }
    }
}

