/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary.cumulative;

import org.chocosolver.solver.ICause;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.nary.cumulative.SweepCumulFilter;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;

public class HeightCumulFilter
extends SweepCumulFilter {
    public HeightCumulFilter(int n) {
        super(n);
        this.FIXPOINT = false;
    }

    protected void pruneMin(IntVar[] s) throws ContradictionException {
    }

    protected void pruneMax(IntVar[] e) throws ContradictionException {
    }

    @Override
    protected boolean sweep(IntVar capamax, IntVar[] h, int nbT, Propagator<IntVar> aCause) throws ContradictionException {
        this.generateMinEvents(nbT);
        if (this.nbEvents == 0) {
            return false;
        }
        this.sort.sort(this.events, this.nbEvents, this.eventComparator);
        int timeIndex = 0;
        int currentDate = this.events[timeIndex].date;
        this.tprune.resetQuick();
        int capa = capamax.getUB();
        int currentConso = 0;
        while (timeIndex < this.nbEvents) {
            int nextDate = this.events[timeIndex].date;
            if (currentDate < nextDate) {
                int i;
                assert (currentConso <= capa);
                this.temp.resetQuick();
                for (i = this.tprune.size() - 1; i >= 0; --i) {
                    int index = this.tprune.get(i);
                    assert (this.sub[index] <= currentDate && currentDate < this.elb[index]);
                    h[this.map[index]].updateUpperBound(capa - (currentConso - this.hlb[index]), (ICause)aCause);
                    if (nextDate >= this.elb[index]) continue;
                    this.temp.add(index);
                }
                this.tprune.resetQuick();
                for (i = this.temp.size() - 1; i >= 0; --i) {
                    this.tprune.add(this.temp.getQuick(i));
                }
            }
            SweepCumulFilter.Event event = this.events[timeIndex++];
            currentDate = event.date;
            if (event.type == 2) {
                capamax.updateLowerBound(currentConso += this.hlb[event.index], (ICause)aCause);
                if (h[this.map[event.index]].isInstantiated()) continue;
                this.tprune.add(event.index);
                continue;
            }
            assert (event.type == 3);
            currentConso -= this.hlb[event.index];
        }
        return false;
    }

    @Override
    protected void generateMinEvents(int nbT) {
        this.nbEvents = 0;
        for (int i = 0; i < nbT; ++i) {
            if (this.sub[i] >= this.elb[i]) continue;
            this.events[this.nbEvents++].set(2, i, this.sub[i]);
            this.events[this.nbEvents++].set(3, i, this.elb[i]);
        }
    }
}

