/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tlong;

import cern.colt.function.tlong.LongFunction;
import cern.colt.function.tlong.LongLongFunction;
import cern.colt.function.tlong.LongProcedure;
import cern.colt.list.tint.IntArrayList;
import cern.colt.list.tlong.LongArrayList;
import cern.colt.matrix.AbstractMatrix1D;
import cern.colt.matrix.tlong.LongMatrix2D;
import cern.colt.matrix.tlong.LongMatrix3D;
import cern.colt.matrix.tlong.algo.LongFormatter;
import cern.colt.matrix.tlong.algo.LongProperty;
import cern.colt.matrix.tlong.algo.LongSorting;
import cern.jet.math.tlong.LongFunctions;
import cern.jet.math.tlong.LongPlusMultSecond;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public abstract class LongMatrix1D
extends AbstractMatrix1D {
    private static final long serialVersionUID = 1L;

    protected LongMatrix1D() {
    }

    public long aggregate(final LongLongFunction longLongFunction, final LongFunction longFunction) {
        if (this.size == 0) {
            throw new IllegalArgumentException("size == 0");
        }
        long l = longFunction.apply(this.getQuick(0));
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            n = Math.min(n, this.size);
            Future[] futureArray = new Future[n];
            int n2 = this.size / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.size : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Callable<Long>(){

                    @Override
                    public Long call() throws Exception {
                        long l = longFunction.apply(LongMatrix1D.this.getQuick(n3));
                        for (int i = n3 + 1; i < n4; ++i) {
                            l = longLongFunction.apply(l, longFunction.apply(LongMatrix1D.this.getQuick(i)));
                        }
                        return l;
                    }
                });
            }
            l = ConcurrencyUtils.waitForCompletion(futureArray, longLongFunction);
        } else {
            for (int i = 1; i < this.size; ++i) {
                l = longLongFunction.apply(l, longFunction.apply(this.getQuick(i)));
            }
        }
        return l;
    }

    public long aggregate(final LongLongFunction longLongFunction, final LongFunction longFunction, IntArrayList intArrayList) {
        if (this.size() == 0L) {
            throw new IllegalArgumentException("size == 0");
        }
        int n = intArrayList.size();
        final int[] nArray = intArrayList.elements();
        long l = 0L;
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && n >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            n2 = Math.min(n2, n);
            Future[] futureArray = new Future[n2];
            int n3 = n / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? n : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Callable<Long>(){

                    @Override
                    public Long call() throws Exception {
                        long l = longFunction.apply(LongMatrix1D.this.getQuick(nArray[n4]));
                        for (int i = n4 + 1; i < n5; ++i) {
                            long l2 = LongMatrix1D.this.getQuick(nArray[i]);
                            l = longLongFunction.apply(l, longFunction.apply(l2));
                        }
                        return l;
                    }
                });
            }
            l = ConcurrencyUtils.waitForCompletion(futureArray, longLongFunction);
        } else {
            l = longFunction.apply(this.getQuick(nArray[0]));
            for (int i = 1; i < n; ++i) {
                long l2 = this.getQuick(nArray[i]);
                l = longLongFunction.apply(l, longFunction.apply(l2));
            }
        }
        return l;
    }

    public long aggregate(final LongMatrix1D longMatrix1D, final LongLongFunction longLongFunction, final LongLongFunction longLongFunction2) {
        this.checkSize(longMatrix1D);
        if (this.size == 0) {
            throw new IllegalArgumentException("size == 0");
        }
        long l = longLongFunction2.apply(this.getQuick(0), longMatrix1D.getQuick(0));
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            n = Math.min(n, this.size);
            Future[] futureArray = new Future[n];
            int n2 = this.size / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.size : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Callable<Long>(){

                    @Override
                    public Long call() throws Exception {
                        long l = longLongFunction2.apply(LongMatrix1D.this.getQuick(n3), longMatrix1D.getQuick(n3));
                        for (int i = n3 + 1; i < n4; ++i) {
                            l = longLongFunction.apply(l, longLongFunction2.apply(LongMatrix1D.this.getQuick(i), longMatrix1D.getQuick(i)));
                        }
                        return l;
                    }
                });
            }
            l = ConcurrencyUtils.waitForCompletion(futureArray, longLongFunction);
        } else {
            for (int i = 1; i < this.size; ++i) {
                l = longLongFunction.apply(l, longLongFunction2.apply(this.getQuick(i), longMatrix1D.getQuick(i)));
            }
        }
        return l;
    }

    public LongMatrix1D assign(final LongFunction longFunction) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            n = Math.min(n, this.size);
            Future[] futureArray = new Future[n];
            int n2 = this.size / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.size : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            LongMatrix1D.this.setQuick(i, longFunction.apply(LongMatrix1D.this.getQuick(i)));
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.size; ++i) {
                this.setQuick(i, longFunction.apply(this.getQuick(i)));
            }
        }
        return this;
    }

    public LongMatrix1D assign(final LongProcedure longProcedure, final LongFunction longFunction) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            n = Math.min(n, this.size);
            Future[] futureArray = new Future[n];
            int n2 = this.size / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.size : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            long l = LongMatrix1D.this.getQuick(i);
                            if (!longProcedure.apply(l)) continue;
                            LongMatrix1D.this.setQuick(i, longFunction.apply(l));
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.size; ++i) {
                long l = this.getQuick(i);
                if (!longProcedure.apply(l)) continue;
                this.setQuick(i, longFunction.apply(l));
            }
        }
        return this;
    }

    public LongMatrix1D assign(final LongProcedure longProcedure, final long l) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            n = Math.min(n, this.size);
            Future[] futureArray = new Future[n];
            int n2 = this.size / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.size : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            long l2 = LongMatrix1D.this.getQuick(i);
                            if (!longProcedure.apply(l2)) continue;
                            LongMatrix1D.this.setQuick(i, l);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.size; ++i) {
                long l2 = this.getQuick(i);
                if (!longProcedure.apply(l2)) continue;
                this.setQuick(i, l);
            }
        }
        return this;
    }

    public LongMatrix1D assign(final long l) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            n = Math.min(n, this.size);
            Future[] futureArray = new Future[n];
            int n2 = this.size / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.size : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            LongMatrix1D.this.setQuick(i, l);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.size; ++i) {
                this.setQuick(i, l);
            }
        }
        return this;
    }

    public LongMatrix1D assign(final long[] lArray) {
        if (lArray.length != this.size) {
            throw new IllegalArgumentException("Must have same number of cells: length=" + lArray.length + "size()=" + this.size());
        }
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            n = Math.min(n, this.size);
            Future[] futureArray = new Future[n];
            int n2 = this.size / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.size : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            LongMatrix1D.this.setQuick(i, lArray[i]);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.size; ++i) {
                this.setQuick(i, lArray[i]);
            }
        }
        return this;
    }

    public LongMatrix1D assign(final int[] nArray) {
        if (nArray.length != this.size) {
            throw new IllegalArgumentException("Must have same number of cells: length=" + nArray.length + "size()=" + this.size());
        }
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            n = Math.min(n, this.size);
            Future[] futureArray = new Future[n];
            int n2 = this.size / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.size : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            LongMatrix1D.this.setQuick(i, nArray[i]);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.size; ++i) {
                this.setQuick(i, nArray[i]);
            }
        }
        return this;
    }

    public LongMatrix1D assign(LongMatrix1D longMatrix1D) {
        if (longMatrix1D == this) {
            return this;
        }
        this.checkSize(longMatrix1D);
        final LongMatrix1D longMatrix1D2 = this.haveSharedCells(longMatrix1D) ? longMatrix1D.copy() : longMatrix1D;
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            n = Math.min(n, this.size);
            Future[] futureArray = new Future[n];
            int n2 = this.size / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.size : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            LongMatrix1D.this.setQuick(i, longMatrix1D2.getQuick(i));
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.size; ++i) {
                this.setQuick(i, longMatrix1D2.getQuick(i));
            }
        }
        return this;
    }

    public LongMatrix1D assign(final LongMatrix1D longMatrix1D, final LongLongFunction longLongFunction) {
        this.checkSize(longMatrix1D);
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            n = Math.min(n, this.size);
            Future[] futureArray = new Future[n];
            int n2 = this.size / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.size : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            LongMatrix1D.this.setQuick(i, longLongFunction.apply(LongMatrix1D.this.getQuick(i), longMatrix1D.getQuick(i)));
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.size; ++i) {
                this.setQuick(i, longLongFunction.apply(this.getQuick(i), longMatrix1D.getQuick(i)));
            }
        }
        return this;
    }

    public LongMatrix1D assign(LongMatrix1D longMatrix1D, LongLongFunction longLongFunction, IntArrayList intArrayList) {
        this.checkSize(longMatrix1D);
        int[] nArray = intArrayList.elements();
        if (longLongFunction == LongFunctions.mult) {
            int n = 0;
            int n2 = intArrayList.size();
            while (--n2 >= 0) {
                int n3 = nArray[n2];
                while (n < n3) {
                    this.setQuick(n, 0L);
                    ++n;
                }
                this.setQuick(n3, this.getQuick(n3) * longMatrix1D.getQuick(n3));
                ++n;
            }
        } else if (longLongFunction instanceof LongPlusMultSecond) {
            long l = ((LongPlusMultSecond)longLongFunction).multiplicator;
            if (l == 0L) {
                return this;
            }
            if (l == 1L) {
                int n = intArrayList.size();
                while (--n >= 0) {
                    int n4 = nArray[n];
                    this.setQuick(n4, this.getQuick(n4) + longMatrix1D.getQuick(n4));
                }
            } else if (l == -1L) {
                int n = intArrayList.size();
                while (--n >= 0) {
                    int n5 = nArray[n];
                    this.setQuick(n5, this.getQuick(n5) - longMatrix1D.getQuick(n5));
                }
            } else {
                int n = intArrayList.size();
                while (--n >= 0) {
                    int n6 = nArray[n];
                    this.setQuick(n6, this.getQuick(n6) + l * longMatrix1D.getQuick(n6));
                }
            }
        } else {
            return this.assign(longMatrix1D, longLongFunction);
        }
        return this;
    }

    public int cardinality() {
        int n = 0;
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            int n3;
            n2 = Math.min(n2, this.size);
            Future[] futureArray = new Future[n2];
            Integer[] integerArray = new Integer[n2];
            int n4 = this.size / n2;
            for (n3 = 0; n3 < n2; ++n3) {
                final int n5 = n3 * n4;
                final int n6 = n3 == n2 - 1 ? this.size : n5 + n4;
                futureArray[n3] = ConcurrencyUtils.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        int n = 0;
                        for (int i = n5; i < n6; ++i) {
                            if (LongMatrix1D.this.getQuick(i) == 0L) continue;
                            ++n;
                        }
                        return n;
                    }
                });
            }
            try {
                for (n3 = 0; n3 < n2; ++n3) {
                    integerArray[n3] = (Integer)futureArray[n3].get();
                }
                n = integerArray[0];
                for (n3 = 1; n3 < n2; ++n3) {
                    n += integerArray[n3].intValue();
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            for (int i = 0; i < this.size; ++i) {
                if (this.getQuick(i) == 0L) continue;
                ++n;
            }
        }
        return n;
    }

    protected int cardinality(int n) {
        int n2 = 0;
        int n3 = this.size;
        while (--n3 >= 0 && n2 < n) {
            if (this.getQuick(n3) == 0L) continue;
            ++n2;
        }
        return n2;
    }

    public LongMatrix1D copy() {
        LongMatrix1D longMatrix1D = this.like();
        longMatrix1D.assign(this);
        return longMatrix1D;
    }

    public abstract Object elements();

    public boolean equals(long l) {
        return LongProperty.DEFAULT.equals(this, l);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof LongMatrix1D)) {
            return false;
        }
        return LongProperty.DEFAULT.equals(this, (LongMatrix1D)object);
    }

    public long get(int n) {
        if (n < 0 || n >= this.size) {
            this.checkIndex(n);
        }
        return this.getQuick(n);
    }

    protected LongMatrix1D getContent() {
        return this;
    }

    public void getNegativeValues(IntArrayList intArrayList, LongArrayList longArrayList) {
        long l;
        intArrayList.clear();
        longArrayList.clear();
        int n = this.size % 2;
        if (n == 1 && (l = this.getQuick(0)) < 0L) {
            intArrayList.add(0);
            longArrayList.add(l);
        }
        for (int i = n; i < this.size; i += 2) {
            long l2 = this.getQuick(i);
            if (l2 < 0L) {
                intArrayList.add(i);
                longArrayList.add(l2);
            }
            if ((l2 = this.getQuick(i + 1)) >= 0L) continue;
            intArrayList.add(i + 1);
            longArrayList.add(l2);
        }
    }

    public void getNonZeros(IntArrayList intArrayList, LongArrayList longArrayList) {
        long l;
        intArrayList.clear();
        longArrayList.clear();
        int n = this.size % 2;
        if (n == 1 && (l = this.getQuick(0)) != 0L) {
            intArrayList.add(0);
            longArrayList.add(l);
        }
        for (int i = n; i < this.size; i += 2) {
            long l2 = this.getQuick(i);
            if (l2 != 0L) {
                intArrayList.add(i);
                longArrayList.add(l2);
            }
            if ((l2 = this.getQuick(i + 1)) == 0L) continue;
            intArrayList.add(i + 1);
            longArrayList.add(l2);
        }
    }

    public void getNonZeros(IntArrayList intArrayList, LongArrayList longArrayList, int n) {
        boolean bl;
        boolean bl2 = intArrayList != null;
        boolean bl3 = bl = longArrayList != null;
        if (bl2) {
            intArrayList.clear();
        }
        if (bl) {
            longArrayList.clear();
        }
        int n2 = this.size;
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            long l = this.getQuick(i);
            if (l != 0L) {
                if (bl2) {
                    intArrayList.add(i);
                }
                if (bl) {
                    longArrayList.add(l);
                }
                ++n3;
            }
            if (n3 >= n) break;
        }
    }

    public void getPositiveValues(IntArrayList intArrayList, LongArrayList longArrayList) {
        long l;
        intArrayList.clear();
        longArrayList.clear();
        int n = this.size % 2;
        if (n == 1 && (l = this.getQuick(0)) > 0L) {
            intArrayList.add(0);
            longArrayList.add(l);
        }
        for (int i = n; i < this.size; i += 2) {
            long l2 = this.getQuick(i);
            if (l2 > 0L) {
                intArrayList.add(i);
                longArrayList.add(l2);
            }
            if ((l2 = this.getQuick(i + 1)) <= 0L) continue;
            intArrayList.add(i + 1);
            longArrayList.add(l2);
        }
    }

    public abstract long getQuick(int var1);

    protected boolean haveSharedCells(LongMatrix1D longMatrix1D) {
        if (longMatrix1D == null) {
            return false;
        }
        if (this == longMatrix1D) {
            return true;
        }
        return this.getContent().haveSharedCellsRaw(longMatrix1D.getContent());
    }

    protected boolean haveSharedCellsRaw(LongMatrix1D longMatrix1D) {
        return false;
    }

    public LongMatrix1D like() {
        return this.like(this.size);
    }

    public abstract LongMatrix1D like(int var1);

    public abstract LongMatrix2D like2D(int var1, int var2);

    public long[] getMaxLocation() {
        int n = 0;
        long l = 0L;
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            int n3;
            n2 = Math.min(n2, this.size);
            Future[] futureArray = new Future[n2];
            long[][] lArray = new long[n2][2];
            int n4 = this.size / n2;
            for (n3 = 0; n3 < n2; ++n3) {
                final int n5 = n3 * n4;
                final int n6 = n3 == n2 - 1 ? this.size : n5 + n4;
                futureArray[n3] = ConcurrencyUtils.submit(new Callable<long[]>(){

                    @Override
                    public long[] call() throws Exception {
                        int n = n5;
                        long l = LongMatrix1D.this.getQuick(n);
                        for (int i = n5 + 1; i < n6; ++i) {
                            long l2 = LongMatrix1D.this.getQuick(i);
                            if (l >= l2) continue;
                            l = l2;
                            n = i;
                        }
                        return new long[]{l, n};
                    }
                });
            }
            try {
                for (n3 = 0; n3 < n2; ++n3) {
                    lArray[n3] = (long[])futureArray[n3].get();
                }
                l = lArray[0][0];
                n = (int)lArray[0][1];
                for (n3 = 1; n3 < n2; ++n3) {
                    if (l >= lArray[n3][0]) continue;
                    l = lArray[n3][0];
                    n = (int)lArray[n3][1];
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            l = this.getQuick(n);
            int n7 = 1;
            while ((long)n7 < this.size()) {
                long l2 = this.getQuick(n7);
                if (l < l2) {
                    l = l2;
                    n = n7;
                }
                ++n7;
            }
        }
        return new long[]{l, n};
    }

    public long[] getMinLocation() {
        int n = 0;
        long l = 0L;
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            int n3;
            n2 = Math.min(n2, this.size);
            Future[] futureArray = new Future[n2];
            long[][] lArray = new long[n2][2];
            int n4 = this.size / n2;
            for (n3 = 0; n3 < n2; ++n3) {
                final int n5 = n3 * n4;
                final int n6 = n3 == n2 - 1 ? this.size : n5 + n4;
                futureArray[n3] = ConcurrencyUtils.submit(new Callable<long[]>(){

                    @Override
                    public long[] call() throws Exception {
                        int n = n5;
                        long l = LongMatrix1D.this.getQuick(n);
                        for (int i = n5 + 1; i < n6; ++i) {
                            long l2 = LongMatrix1D.this.getQuick(i);
                            if (l <= l2) continue;
                            l = l2;
                            n = i;
                        }
                        return new long[]{l, n};
                    }
                });
            }
            try {
                for (n3 = 0; n3 < n2; ++n3) {
                    lArray[n3] = (long[])futureArray[n3].get();
                }
                l = lArray[0][0];
                n = (int)lArray[0][1];
                for (n3 = 1; n3 < n2; ++n3) {
                    if (l <= lArray[n3][0]) continue;
                    l = lArray[n3][0];
                    n = (int)lArray[n3][1];
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            l = this.getQuick(n);
            int n7 = 1;
            while ((long)n7 < this.size()) {
                long l2 = this.getQuick(n7);
                if (l > l2) {
                    l = l2;
                    n = n7;
                }
                ++n7;
            }
        }
        return new long[]{l, n};
    }

    public abstract LongMatrix2D reshape(int var1, int var2);

    public abstract LongMatrix3D reshape(int var1, int var2, int var3);

    public void set(int n, long l) {
        if (n < 0 || n >= this.size) {
            this.checkIndex(n);
        }
        this.setQuick(n, l);
    }

    public abstract void setQuick(int var1, long var2);

    public void setSize(int n) {
        this.size = n;
    }

    public void swap(final LongMatrix1D longMatrix1D) {
        this.checkSize(longMatrix1D);
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            n = Math.min(n, this.size);
            Future[] futureArray = new Future[n];
            int n2 = this.size / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.size : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            long l = LongMatrix1D.this.getQuick(i);
                            LongMatrix1D.this.setQuick(i, longMatrix1D.getQuick(i));
                            longMatrix1D.setQuick(i, l);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.size; ++i) {
                long l = this.getQuick(i);
                this.setQuick(i, longMatrix1D.getQuick(i));
                longMatrix1D.setQuick(i, l);
            }
        }
    }

    public long[] toArray() {
        long[] lArray = new long[this.size];
        this.toArray(lArray);
        return lArray;
    }

    public void toArray(final long[] lArray) {
        if (lArray.length < this.size) {
            throw new IllegalArgumentException("values too small");
        }
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            n = Math.min(n, this.size);
            Future[] futureArray = new Future[n];
            int n2 = this.size / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.size : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            lArray[i] = LongMatrix1D.this.getQuick(i);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.size; ++i) {
                lArray[i] = this.getQuick(i);
            }
        }
    }

    public String toString() {
        return new LongFormatter().toString(this);
    }

    protected LongMatrix1D view() {
        return (LongMatrix1D)this.clone();
    }

    public LongMatrix1D viewFlip() {
        return (LongMatrix1D)this.view().vFlip();
    }

    public LongMatrix1D viewPart(int n, int n2) {
        return (LongMatrix1D)this.view().vPart(n, n2);
    }

    public LongMatrix1D viewSelection(LongProcedure longProcedure) {
        IntArrayList intArrayList = new IntArrayList();
        for (int i = 0; i < this.size; ++i) {
            if (!longProcedure.apply(this.getQuick(i))) continue;
            intArrayList.add(i);
        }
        intArrayList.trimToSize();
        return this.viewSelection(intArrayList.elements());
    }

    public LongMatrix1D viewSelection(int[] nArray) {
        if (nArray == null) {
            nArray = new int[this.size];
            for (int i = 0; i < this.size; ++i) {
                nArray[i] = i;
            }
        }
        this.checkIndexes(nArray);
        int[] nArray2 = new int[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray2[i] = (int)this.index(nArray[i]);
        }
        return this.viewSelectionLike(nArray2);
    }

    protected abstract LongMatrix1D viewSelectionLike(int[] var1);

    public LongMatrix1D viewSorted() {
        return LongSorting.mergeSort.sort(this);
    }

    public LongMatrix1D viewStrides(int n) {
        return (LongMatrix1D)this.view().vStrides(n);
    }

    public long zDotProduct(LongMatrix1D longMatrix1D) {
        return this.zDotProduct(longMatrix1D, 0, this.size);
    }

    public long zDotProduct(final LongMatrix1D longMatrix1D, final int n, int n2) {
        if (n < 0 || n2 <= 0) {
            return 0L;
        }
        int n3 = n + n2;
        if (this.size < n3) {
            n3 = this.size;
        }
        if (longMatrix1D.size < n3) {
            n3 = longMatrix1D.size;
        }
        n2 = n3 - n;
        long l = 0L;
        int n4 = ConcurrencyUtils.getNumberOfThreads();
        if (n4 > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            int n5;
            n4 = Math.min(n4, n2);
            Future[] futureArray = new Future[n4];
            Long[] longArray = new Long[n4];
            int n6 = n2 / n4;
            for (n5 = 0; n5 < n4; ++n5) {
                final int n7 = n5 * n6;
                final int n8 = n5 == n4 - 1 ? n2 : n7 + n6;
                futureArray[n5] = ConcurrencyUtils.submit(new Callable<Long>(){

                    @Override
                    public Long call() throws Exception {
                        long l = 0L;
                        for (int i = n7; i < n8; ++i) {
                            int n2 = i + n;
                            l += LongMatrix1D.this.getQuick(n2) * longMatrix1D.getQuick(n2);
                        }
                        return l;
                    }
                });
            }
            try {
                for (n5 = 0; n5 < n4; ++n5) {
                    longArray[n5] = (Long)futureArray[n5].get();
                }
                l = longArray[0];
                for (n5 = 1; n5 < n4; ++n5) {
                    l += longArray[n5].longValue();
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            int n9 = n3 - 1;
            int n10 = n2;
            while (--n10 >= 0) {
                l += this.getQuick(n9) * longMatrix1D.getQuick(n9);
                --n9;
            }
        }
        return l;
    }

    public long zDotProduct(LongMatrix1D longMatrix1D, int n, int n2, IntArrayList intArrayList) {
        int n3;
        int n4;
        if (n < 0 || n2 <= 0) {
            return 0L;
        }
        int n5 = n + n2;
        if (this.size < n5) {
            n5 = this.size;
        }
        if (longMatrix1D.size < n5) {
            n5 = longMatrix1D.size;
        }
        if ((n2 = n5 - n) <= 0) {
            return 0L;
        }
        IntArrayList intArrayList2 = intArrayList.copy();
        intArrayList2.trimToSize();
        intArrayList2.quickSort();
        int[] nArray = intArrayList2.elements();
        int n6 = intArrayList2.size();
        for (n4 = 0; n4 < n6 && nArray[n4] < n; ++n4) {
        }
        long l = 0L;
        while (--n2 >= 0 && n4 < n6 && (n3 = nArray[n4]) < n5) {
            l += this.getQuick(n3) * longMatrix1D.getQuick(n3);
            ++n4;
        }
        return l;
    }

    protected long zDotProduct(LongMatrix1D longMatrix1D, IntArrayList intArrayList) {
        return this.zDotProduct(longMatrix1D, 0, this.size, intArrayList);
    }

    public long zSum() {
        if (this.size() == 0L) {
            return 0L;
        }
        return this.aggregate(LongFunctions.plus, LongFunctions.identity);
    }
}

