/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.distribution.shrinkage;

import dr.inference.distribution.shrinkage.BayesianBridgeStatisticsProvider;
import dr.inference.model.Parameter;
import java.util.List;

public class JointBayesianBridgeStatistics
implements BayesianBridgeStatisticsProvider {
    private final List<BayesianBridgeStatisticsProvider> providers;

    public JointBayesianBridgeStatistics(List<BayesianBridgeStatisticsProvider> list) {
        this.providers = list;
        BayesianBridgeStatisticsProvider bayesianBridgeStatisticsProvider = list.get(0);
        for (int i = 1; i < list.size(); ++i) {
            BayesianBridgeStatisticsProvider bayesianBridgeStatisticsProvider2 = list.get(i);
            if (BayesianBridgeStatisticsProvider.equivalent(bayesianBridgeStatisticsProvider, bayesianBridgeStatisticsProvider2)) continue;
            throw new IllegalArgumentException("All Bayesian bridges must be the same");
        }
    }

    @Override
    public double getCoefficient(int n) {
        double d = 0.0;
        for (BayesianBridgeStatisticsProvider bayesianBridgeStatisticsProvider : this.providers) {
            d += bayesianBridgeStatisticsProvider.getCoefficient(n) * bayesianBridgeStatisticsProvider.getCoefficient(n);
        }
        return Math.sqrt(d);
    }

    @Override
    public Parameter getGlobalScale() {
        return this.providers.get(0).getGlobalScale();
    }

    @Override
    public Parameter getLocalScale() {
        return this.providers.get(0).getLocalScale();
    }

    @Override
    public Parameter getExponent() {
        return this.providers.get(0).getExponent();
    }

    @Override
    public Parameter getSlabWidth() {
        return this.providers.get(0).getSlabWidth();
    }

    @Override
    public int getDimension() {
        return this.providers.get(0).getDimension();
    }
}

