/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.treedatalikelihood.continuous;

import dr.evomodel.treedatalikelihood.BufferIndexHelper;
import dr.evomodel.treedatalikelihood.continuous.ConjugateRootTraitPrior;
import dr.evomodel.treedatalikelihood.continuous.cdi.ContinuousDiffusionIntegrator;
import dr.evomodel.treedatalikelihood.continuous.cdi.PrecisionType;
import dr.inference.model.AbstractModel;
import dr.inference.model.Model;
import dr.inference.model.Variable;

public interface RootProcessDelegate
extends Model {
    public int getExtraPartialBufferCount();

    public int getExtraMatrixBufferCount();

    public void calculateRootLogLikelihood(ContinuousDiffusionIntegrator var1, int var2, int var3, double[] var4, boolean var5, boolean var6);

    public double getPseudoObservations();

    public int getPriorBufferIndex();

    public static class FullyConjugate
    extends Abstract {
        FullyConjugate(ConjugateRootTraitPrior conjugateRootTraitPrior, PrecisionType precisionType, int n, int n2, int n3) {
            super(conjugateRootTraitPrior, precisionType, n, n2, n3);
        }

        @Override
        public double getPseudoObservations() {
            return this.prior.getPseudoObservations();
        }
    }

    public static class Fixed
    extends Abstract {
        public Fixed(ConjugateRootTraitPrior conjugateRootTraitPrior, PrecisionType precisionType, int n, int n2, int n3) {
            super(conjugateRootTraitPrior, precisionType, n, n2, n3);
        }

        @Override
        public double getPseudoObservations() {
            return Double.POSITIVE_INFINITY;
        }
    }

    public static abstract class Abstract
    extends AbstractModel
    implements RootProcessDelegate {
        protected final ConjugateRootTraitPrior prior;
        private final PrecisionType precisionType;
        private final int numTraits;
        private final int priorBufferIndexOffset;
        private final BufferIndexHelper priorBufferIndex;
        private boolean updatePrior;

        @Override
        public abstract double getPseudoObservations();

        public Abstract(ConjugateRootTraitPrior conjugateRootTraitPrior, PrecisionType precisionType, int n, int n2, int n3) {
            super("RootProcessDelegate");
            this.prior = conjugateRootTraitPrior;
            this.precisionType = precisionType;
            this.numTraits = n;
            this.priorBufferIndexOffset = n2;
            this.priorBufferIndex = new BufferIndexHelper(1, 0);
            if (conjugateRootTraitPrior != null) {
                this.addModel(conjugateRootTraitPrior);
            }
            this.updatePrior = true;
        }

        @Override
        public int getExtraPartialBufferCount() {
            return 2;
        }

        @Override
        public int getExtraMatrixBufferCount() {
            return 0;
        }

        @Override
        public int getPriorBufferIndex() {
            return this.priorBufferIndexOffset + this.priorBufferIndex.getOffsetIndex(0);
        }

        @Override
        public void calculateRootLogLikelihood(ContinuousDiffusionIntegrator continuousDiffusionIntegrator, int n, int n2, double[] dArray, boolean bl, boolean bl2) {
            if (this.updatePrior) {
                this.setRootPartial(continuousDiffusionIntegrator);
                this.updatePrior = false;
            }
            continuousDiffusionIntegrator.calculateRootLogLikelihood(n, this.getPriorBufferIndex(), n2, dArray, bl, bl2);
        }

        private void setRootPartial(ContinuousDiffusionIntegrator continuousDiffusionIntegrator) {
            double[] dArray = this.prior.getMean();
            int n = dArray.length;
            int n2 = this.precisionType.getPartialsDimension(n);
            double[] dArray2 = new double[n2 * this.numTraits];
            int n3 = 0;
            for (int i = 0; i < this.numTraits; ++i) {
                System.arraycopy(dArray, 0, dArray2, n3, n);
                double d = this.getPseudoObservations();
                for (int j = 0; j < n; ++j) {
                    this.precisionType.fillPrecisionInPartials(dArray2, n3, j, d, n);
                }
                if (d != 0.0) {
                    this.precisionType.fillEffDimInPartials(dArray2, n3, n, n);
                }
                n3 += n2;
            }
            this.priorBufferIndex.flipOffset(0);
            continuousDiffusionIntegrator.setPostOrderPartial(this.getPriorBufferIndex(), dArray2);
        }

        @Override
        protected void handleModelChangedEvent(Model model, Object object, int n) {
            if (model != this.prior) {
                throw new IllegalArgumentException("Unknown submodel");
            }
            this.updatePrior = true;
            this.fireModelChanged(object);
        }

        @Override
        protected void storeState() {
            this.priorBufferIndex.storeState();
        }

        @Override
        protected void restoreState() {
            this.priorBufferIndex.restoreState();
        }

        @Override
        protected void acceptState() {
        }

        @Override
        protected void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
            throw new IllegalArgumentException("No subvariables");
        }
    }
}

