/*
 * Decompiled with CFR 0.152.
 */
package dr.evolution.tree;

import dr.evolution.tree.NodeRef;
import dr.evolution.util.Taxon;
import dr.evolution.util.TaxonList;
import dr.evolution.util.Units;
import dr.util.Attributable;
import dr.util.Identifiable;
import java.util.Iterator;

public interface Tree
extends TaxonList,
Units,
Identifiable,
Attributable {
    public NodeRef getRoot();

    public int getNodeCount();

    public NodeRef getNode(int var1);

    public NodeRef getInternalNode(int var1);

    public NodeRef getExternalNode(int var1);

    public int getExternalNodeCount();

    public int getInternalNodeCount();

    public Taxon getNodeTaxon(NodeRef var1);

    public boolean hasNodeHeights();

    public double getNodeHeight(NodeRef var1);

    public boolean hasBranchLengths();

    public double getBranchLength(NodeRef var1);

    @Deprecated
    public double getNodeRate(NodeRef var1);

    @Deprecated
    public Object getNodeAttribute(NodeRef var1, String var2);

    @Deprecated
    public Iterator getNodeAttributeNames(NodeRef var1);

    public boolean isExternal(NodeRef var1);

    public boolean isRoot(NodeRef var1);

    public int getChildCount(NodeRef var1);

    public NodeRef getChild(NodeRef var1, int var2);

    public NodeRef getParent(NodeRef var1);

    public Tree getCopy();

    public static double getTreeLength(Tree tree) {
        double d = 0.0;
        for (int i = 0; i < tree.getNodeCount(); ++i) {
            NodeRef nodeRef = tree.getNode(i);
            if (tree.isRoot(nodeRef)) continue;
            d += tree.getBranchLength(nodeRef);
        }
        return d;
    }
}

