/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.api.util;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Spliterator;
import java.util.function.IntConsumer;
import java.util.function.IntPredicate;
import java.util.function.IntUnaryOperator;
import java.util.stream.IntStream;
import nbbrd.design.PrimitiveReplacementOf;

@PrimitiveReplacementOf(generic=List.class, primitive=int.class)
public final class IntList {
    public static final int[] EMPTY = new int[0];
    private static final int DEFAULT_SIZE = 128;
    private int[] array;
    private int limit;
    private int fillval = 0;

    public IntList() {
        this(128);
    }

    public IntList(int initialCapacity) {
        this(initialCapacity, 0);
    }

    public IntList(IntList list) {
        this(list.array.length);
        System.arraycopy(list.array, 0, this.array, 0, this.array.length);
        this.limit = list.limit;
    }

    public IntList(int initialCapacity, int fillvalue) {
        this.array = new int[initialCapacity];
        if (this.fillval != 0) {
            this.fillval = fillvalue;
            Arrays.fill(this.array, this.fillval);
        }
        this.limit = 0;
    }

    public void add(int index, int value) {
        if (index > this.limit) {
            throw new IndexOutOfBoundsException();
        }
        if (index == this.limit) {
            this.add(value);
        } else {
            if (this.limit == this.array.length) {
                this.growArray(this.limit * 2);
            }
            System.arraycopy(this.array, index, this.array, index + 1, this.limit - index);
            this.array[index] = value;
            ++this.limit;
        }
    }

    public boolean add(int value) {
        if (this.limit == this.array.length) {
            this.growArray(this.limit * 2);
        }
        this.array[this.limit++] = value;
        return true;
    }

    public boolean addAll(IntList c) {
        if (c.limit != 0) {
            if (this.limit + c.limit > this.array.length) {
                this.growArray(this.limit + c.limit);
            }
            System.arraycopy(c.array, 0, this.array, this.limit, c.limit);
            this.limit += c.limit;
        }
        return true;
    }

    public boolean addAll(int index, IntList c) {
        if (index > this.limit) {
            throw new IndexOutOfBoundsException();
        }
        if (c.limit != 0) {
            if (this.limit + c.limit > this.array.length) {
                this.growArray(this.limit + c.limit);
            }
            System.arraycopy(this.array, index, this.array, index + c.limit, this.limit - index);
            System.arraycopy(c.array, 0, this.array, index, c.limit);
            this.limit += c.limit;
        }
        return true;
    }

    public void clear() {
        this.limit = 0;
    }

    public boolean contains(int o) {
        boolean rval = false;
        for (int j = 0; !rval && j < this.limit; ++j) {
            if (this.array[j] != o) continue;
            rval = true;
        }
        return rval;
    }

    public boolean containsAll(IntList c) {
        boolean rval = true;
        if (this != c) {
            for (int j = 0; rval && j < c.limit; ++j) {
                if (this.contains(c.array[j])) continue;
                rval = false;
            }
        }
        return rval;
    }

    public boolean equals(Object o) {
        boolean rval;
        boolean bl = rval = this == o;
        if (!rval && o != null && o.getClass() == this.getClass()) {
            IntList other = (IntList)o;
            if (other.limit == this.limit) {
                rval = true;
                for (int j = 0; rval && j < this.limit; ++j) {
                    rval = this.array[j] == other.array[j];
                }
            }
        }
        return rval;
    }

    public int get(int index) {
        if (index >= this.limit) {
            throw new IndexOutOfBoundsException();
        }
        return this.array[index];
    }

    public int hashCode() {
        int hash = 0;
        for (int j = 0; j < this.limit; ++j) {
            hash = 31 * hash + this.array[j];
        }
        return hash;
    }

    public int indexOf(int o) {
        int rval;
        for (rval = 0; rval < this.limit && o != this.array[rval]; ++rval) {
        }
        if (rval == this.limit) {
            rval = -1;
        }
        return rval;
    }

    public boolean isEmpty() {
        return this.limit == 0;
    }

    public int lastIndexOf(int o) {
        int rval;
        for (rval = this.limit - 1; rval >= 0 && o != this.array[rval]; --rval) {
        }
        return rval;
    }

    public int remove(int index) {
        if (index >= this.limit) {
            throw new IndexOutOfBoundsException();
        }
        int rval = this.array[index];
        System.arraycopy(this.array, index + 1, this.array, index, this.limit - index);
        --this.limit;
        return rval;
    }

    public boolean removeValue(int value) {
        for (int j = 0; j < this.limit; ++j) {
            if (value != this.array[j]) continue;
            int nextIndex = j + 1;
            if (nextIndex < this.limit) {
                System.arraycopy(this.array, nextIndex, this.array, j, this.limit - nextIndex);
            }
            --this.limit;
            return true;
        }
        return false;
    }

    public boolean removeAll(IntList c) {
        boolean rval = false;
        for (int j = 0; j < c.limit; ++j) {
            if (!this.removeValue(c.array[j])) continue;
            rval = true;
        }
        return rval;
    }

    public boolean retainAll(IntList c) {
        boolean rval = false;
        int j = 0;
        while (j < this.limit) {
            if (!c.contains(this.array[j])) {
                this.remove(j);
                rval = true;
                continue;
            }
            ++j;
        }
        return rval;
    }

    public int set(int index, int element) {
        if (index >= this.limit) {
            throw new IndexOutOfBoundsException();
        }
        int rval = this.array[index];
        this.array[index] = element;
        return rval;
    }

    public int size() {
        return this.limit;
    }

    public int[] toArray() {
        if (this.limit == 0) {
            return EMPTY;
        }
        int[] rval = new int[this.limit];
        System.arraycopy(this.array, 0, rval, 0, this.limit);
        return rval;
    }

    public int[] toArray(int[] a) {
        int[] rval;
        if (a.length == this.limit) {
            System.arraycopy(this.array, 0, a, 0, this.limit);
            rval = a;
        } else {
            rval = this.toArray();
        }
        return rval;
    }

    private void growArray(int new_size) {
        int size = new_size == this.array.length ? new_size + 1 : new_size;
        int[] new_array = new int[size];
        if (this.fillval != 0) {
            Arrays.fill(new_array, this.array.length, new_array.length, this.fillval);
        }
        System.arraycopy(this.array, 0, new_array, 0, this.limit);
        this.array = new_array;
    }

    public IntStream stream() {
        return Arrays.stream(this.array, 0, this.limit);
    }

    public void replaceAll(IntUnaryOperator operator) {
        Objects.requireNonNull(operator);
        for (int i = 0; i < this.limit; ++i) {
            this.array[i] = operator.applyAsInt(this.array[i]);
        }
    }

    public void sort() {
        Arrays.sort(this.array, 0, this.limit);
    }

    public Spliterator.OfInt spliterator() {
        return Arrays.spliterator(this.array, 0, this.limit);
    }

    public boolean removeIf(IntPredicate filter) {
        Objects.requireNonNull(filter);
        boolean removed = false;
        int i = 0;
        while (i < this.limit) {
            if (filter.test(this.array[i])) {
                this.remove(i);
                removed = true;
                continue;
            }
            ++i;
        }
        return removed;
    }

    public void forEach(IntConsumer action) {
        Objects.requireNonNull(action);
        for (int i = 0; i < this.limit; ++i) {
            action.accept(this.array[i]);
        }
    }
}

