/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.api.information;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import jdplus.toolkit.base.api.information.BasicInformationExtractor;
import jdplus.toolkit.base.api.information.InformationExtractors;
import jdplus.toolkit.base.api.util.WildCards;

class BasicInformationExtractors {
    static final String LSTART = "(";
    static final String LEND = ")";

    BasicInformationExtractors() {
    }

    static String listKey(String prefix, int item) {
        StringBuilder builder = new StringBuilder();
        builder.append(prefix).append(LSTART).append(item).append(LEND);
        return builder.toString();
    }

    static int listItem(String prefix, String key, int defValue) {
        if (!key.startsWith(prefix)) {
            return Integer.MIN_VALUE;
        }
        if (key.equals(prefix)) {
            return defValue;
        }
        int start = prefix.length() + LSTART.length();
        int end = key.length() - LEND.length();
        if (end <= start) {
            return Integer.MIN_VALUE;
        }
        String s = key.substring(start, end);
        if (BasicInformationExtractors.iswc(s)) {
            return defValue;
        }
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException ex) {
            return Integer.MIN_VALUE;
        }
    }

    static boolean iswc(String id) {
        return (id = id.trim()).length() == 1 && id.charAt(0) == '*' || id.charAt(0) == '?';
    }

    static String wcKey(String prefix, char wc) {
        StringBuilder builder = new StringBuilder();
        builder.append(prefix).append(LSTART);
        builder.append(wc).append(LEND);
        return builder.toString();
    }

    static class ArrayExtractorDelegate<S, T>
    implements BasicInformationExtractor<S> {
        final String name;
        final BiFunction<S, Integer, T> fn;
        final Class<T> target;
        final int start;
        final int end;

        ArrayExtractorDelegate(String name, int start, int end, Class<T> target, BiFunction<S, Integer, T> fn) {
            this.name = name;
            this.fn = fn;
            this.target = target;
            this.start = start;
            this.end = end;
        }

        @Override
        public void fillDictionary(String prefix, Map<String, Class> dic, boolean compact) {
            if (compact) {
                String item = BasicInformationExtractors.wcKey(this.name, this.start == this.end ? (char)'?' : '*');
                InformationExtractors.fillDictionary(this.target, BasicInformationExtractor.concatenate(prefix, item), dic, compact);
            } else if (this.start == this.end) {
                String item = BasicInformationExtractors.listKey(this.name, this.start);
                InformationExtractors.fillDictionary(this.target, BasicInformationExtractor.concatenate(prefix, item), dic, compact);
            } else {
                for (int i = this.start; i < this.end; ++i) {
                    String item = BasicInformationExtractors.listKey(this.name, i);
                    InformationExtractors.fillDictionary(this.target, BasicInformationExtractor.concatenate(prefix, item), dic, compact);
                }
            }
        }

        @Override
        public boolean contains(String id) {
            int idx = BasicInformationExtractors.listItem(this.name, id, this.start);
            return InformationExtractors.contains(this.target, ArrayExtractorDelegate.detail(id));
        }

        @Override
        public <Q> Q getData(S source, String id, Class<Q> qclass) {
            if (source == null) {
                return null;
            }
            int idx = BasicInformationExtractors.listItem(this.name, id, this.start);
            if (idx == Integer.MIN_VALUE) {
                return null;
            }
            T t = this.fn.apply(source, idx);
            if (t == null) {
                return null;
            }
            String detail = ArrayExtractorDelegate.detail(id);
            return InformationExtractors.getData(this.target, t, detail, qclass);
        }

        static String detail(String key) {
            int pos = key.indexOf(BasicInformationExtractors.LEND);
            if (pos <= 0) {
                return null;
            }
            return key.substring(pos + 2);
        }
    }

    static class ExtractorDelegate<S, T>
    implements BasicInformationExtractor<S> {
        final String name;
        final Function<S, T> fn;
        final Class<T> target;

        ExtractorDelegate(String name, Class<T> target, Function<S, T> fn) {
            this.name = name == null || name.length() == 0 ? null : name;
            this.fn = fn;
            this.target = target;
        }

        @Override
        public void fillDictionary(String prefix, Map<String, Class> dic, boolean compact) {
            InformationExtractors.fillDictionary(this.target, BasicInformationExtractor.concatenate(prefix, this.name), dic, compact);
        }

        @Override
        public boolean contains(String id) {
            if (this.name == null) {
                return InformationExtractors.contains(this.target, id);
            }
            if (id.length() <= this.name.length()) {
                return false;
            }
            if (id.startsWith(this.name) && id.charAt(this.name.length()) == '.') {
                return InformationExtractors.contains(this.target, id.substring(this.name.length() + 1));
            }
            return false;
        }

        @Override
        public <Q> Q getData(S source, String id, Class<Q> qclass) {
            if (source == null) {
                return null;
            }
            T t = this.fn.apply(source);
            if (t == null) {
                return null;
            }
            String subitem = id;
            if (this.name != null) {
                if (id.length() <= this.name.length()) {
                    return null;
                }
                if (!id.startsWith(this.name) || id.charAt(this.name.length()) != '.') {
                    return null;
                }
                subitem = id.substring(this.name.length() + 1);
            }
            return InformationExtractors.getData(this.target, t, subitem, qclass);
        }

        @Override
        public <Q> void searchAll(S source, WildCards wc, Class<Q> tclass, Map<String, Q> map) {
            String wcs = wc.toString();
            if (this.name != null && wcs.startsWith(this.name) && wcs.charAt(this.name.length()) == '.') {
                String subwcs = wcs.substring(this.name.length() + 1);
                LinkedHashMap<String, Object> tmap = new LinkedHashMap<String, Object>();
                InformationExtractors.searchAll(this.target, this.fn.apply(source), new WildCards(subwcs), tclass, tmap);
                if (!tmap.isEmpty()) {
                    tmap.forEach((key, value) -> map.put(BasicInformationExtractor.concatenate(this.name, key), value));
                }
                return;
            }
            InformationExtractors.searchAll(this.target, this.fn.apply(source), wc, tclass, map);
        }
    }

    static class ArrayExtractor<S>
    implements BasicInformationExtractor<S> {
        final String name;
        final Class<?> targetClass;
        final BiFunction<S, Integer, ?> fn;
        final int start;
        final int end;

        <T> ArrayExtractor(String name, int start, int end, Class<T> targetClass, BiFunction<S, Integer, T> fn) {
            this.name = name;
            this.targetClass = targetClass;
            this.fn = fn;
            this.start = start;
            this.end = end;
        }

        @Override
        public void fillDictionary(String prefix, Map<String, Class> dic, boolean compact) {
            if (compact) {
                String item = BasicInformationExtractors.wcKey(this.name, this.start == this.end ? (char)'?' : '*');
                dic.put(BasicInformationExtractor.concatenate(prefix, item), this.targetClass);
            } else if (this.start == this.end) {
                dic.put(BasicInformationExtractor.concatenate(prefix, BasicInformationExtractors.listKey(this.name, this.start)), this.targetClass);
            } else {
                for (int i = this.start; i < this.end; ++i) {
                    dic.put(BasicInformationExtractor.concatenate(prefix, BasicInformationExtractors.listKey(this.name, i)), this.targetClass);
                }
            }
        }

        @Override
        public boolean contains(String id) {
            int idx = BasicInformationExtractors.listItem(this.name, id, this.start);
            return idx != Integer.MIN_VALUE;
        }

        @Override
        public <T> T getData(S source, String id, Class<T> tclass) {
            if (source == null) {
                return null;
            }
            if (tclass.isAssignableFrom(this.targetClass)) {
                int idx = BasicInformationExtractors.listItem(this.name, id, this.start);
                if (idx == Integer.MIN_VALUE) {
                    return null;
                }
                return (T)this.fn.apply(source, idx);
            }
            return null;
        }

        @Override
        public <T> void searchAll(S source, WildCards wc, Class<T> tclass, Map<String, T> map) {
            if (tclass.isAssignableFrom(this.targetClass)) {
                int endc = this.end;
                if (this.start == this.end) {
                    ++endc;
                }
                for (int i = this.start; i < this.end; ++i) {
                    String key = BasicInformationExtractors.listKey(this.name, i);
                    if (!wc.match(key)) continue;
                    Object obj = this.fn.apply(source, i);
                    if (obj == null) {
                        return;
                    }
                    map.put(key, obj);
                }
            }
        }
    }

    static class AtomicExtractor<S>
    implements BasicInformationExtractor<S> {
        final String name;
        final Class<?> targetClass;
        final Function<S, ?> fn;

        <T> AtomicExtractor(String name, Class<T> targetClass, Function<S, T> fn) {
            this.name = name;
            this.targetClass = targetClass;
            this.fn = fn;
        }

        @Override
        public void fillDictionary(String prefix, Map<String, Class> dic, boolean compact) {
            dic.put(BasicInformationExtractor.concatenate(prefix, this.name), this.targetClass);
        }

        @Override
        public boolean contains(String id) {
            return id.equals(this.name);
        }

        @Override
        public <T> T getData(S source, String id, Class<T> tclass) {
            if (source == null) {
                return null;
            }
            if (tclass.isAssignableFrom(this.targetClass) && id.equals(this.name)) {
                return (T)this.fn.apply(source);
            }
            return null;
        }

        @Override
        public <T> void searchAll(S source, WildCards wc, Class<T> tclass, Map<String, T> map) {
            if (tclass.isAssignableFrom(this.targetClass) && wc.match(this.name)) {
                map.put(this.name, this.fn.apply(source));
            }
        }
    }
}

