/*
 * Decompiled with CFR 0.152.
 */
package jdplus.sa.base.core.tests;

import jdplus.sa.base.core.tests.Ranking;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.dstats.ContinuousDistribution;
import jdplus.toolkit.base.api.stats.StatisticalTest;
import jdplus.toolkit.base.api.stats.TestType;
import jdplus.toolkit.base.core.data.DataBlockIterator;
import jdplus.toolkit.base.core.dstats.Chi2;
import jdplus.toolkit.base.core.dstats.F;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.stats.tests.TestsUtility;

public class Friedman {
    private boolean useChi2 = true;
    private final int n;
    private final int period;
    private double sst;
    private final double sse;
    private final double t;

    public Friedman(DoubleSeq all, int period) {
        int nall = all.length();
        this.period = period;
        this.n = nall / period;
        DoubleSeq x = all.drop(nall - this.n * this.period, 0);
        DoubleSeq y = x.extract(0, period);
        FastMatrix R = FastMatrix.make((int)this.n, (int)this.period);
        int row = 0;
        int start = 0;
        for (int i = 0; i < this.n; ++i) {
            Ranking.sort(y, R.row(row++));
            y = x.extract(start += period, period);
        }
        double rmean = R.sum() / (double)(this.n * this.period);
        this.sst = 0.0;
        DataBlockIterator cols = R.columnsIterator();
        while (cols.hasNext()) {
            double tmp = cols.next().sum() / (double)this.n - rmean;
            this.sst += tmp * tmp;
        }
        this.sst *= (double)this.n;
        R.sub(rmean);
        this.sse = R.ssq() / (double)(this.n * (this.period - 1));
        this.t = this.sst / this.sse;
    }

    public Friedman useChi2(boolean chi2) {
        this.useChi2 = chi2;
        return this;
    }

    public int getPeriod() {
        return this.period;
    }

    public int getN() {
        return this.n;
    }

    public double getSse() {
        return this.sse;
    }

    public double getSst() {
        return this.sst;
    }

    public double getT() {
        return this.t;
    }

    public StatisticalTest build() {
        int nk = this.n * (this.period - 1);
        if (!this.useChi2 && this.t < (double)nk) {
            F ftest = new F((double)(this.period - 1), (double)((this.period - 1) * (this.n - 1)));
            return TestsUtility.testOf((double)((double)(this.n - 1) * this.t / ((double)nk - this.t)), (ContinuousDistribution)ftest, (TestType)TestType.Upper);
        }
        Chi2 chi2 = new Chi2((double)(this.period - 1));
        return TestsUtility.testOf((double)this.t, (ContinuousDistribution)chi2, (TestType)TestType.Upper);
    }
}

