/*
 * Decompiled with CFR 0.152.
 */
package com.miraisolutions.xlconnect;

import com.miraisolutions.xlconnect.Attribute;
import java.util.Collections;
import java.util.Map;

public class ResultWithAttributes<T> {
    private final T value;
    private final Map<String, String[]> attributes;

    public ResultWithAttributes(T value, Map<String, String[]> theAttributes) {
        this.value = value;
        this.attributes = theAttributes;
    }

    public ResultWithAttributes(T value) {
        this(value, Collections.emptyMap());
    }

    public ResultWithAttributes(T value, Attribute attributeName, String attributeValue) {
        this(value, Collections.singletonMap(attributeName.toString(), new String[]{attributeValue}));
    }

    public T getValue() {
        return this.value;
    }

    public Map<String, String[]> getAttributes() {
        return Collections.unmodifiableMap(this.attributes);
    }

    public String[] getAttributeNames() {
        return this.attributes.keySet().toArray(new String[0]);
    }

    public String[] getAttributeValue(String attributeName) {
        return this.attributes.get(attributeName);
    }
}

