/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdouble.algo.solver;

import cern.colt.matrix.tdouble.DoubleMatrix1D;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.algo.solver.AbstractDoubleIterativeSolver;
import cern.colt.matrix.tdouble.algo.solver.DoubleNotConvergedException;
import cern.colt.matrix.tdouble.algo.solver.IterativeSolverDoubleNotConvergedException;
import cern.jet.math.tdouble.DoubleFunctions;

public class DoubleBiCG
extends AbstractDoubleIterativeSolver {
    private DoubleMatrix1D z;
    private DoubleMatrix1D p;
    private DoubleMatrix1D q;
    private DoubleMatrix1D r;
    private DoubleMatrix1D ztilde;
    private DoubleMatrix1D ptilde;
    private DoubleMatrix1D qtilde;
    private DoubleMatrix1D rtilde;

    public DoubleBiCG(DoubleMatrix1D doubleMatrix1D) {
        this.z = doubleMatrix1D.copy();
        this.p = doubleMatrix1D.copy();
        this.q = doubleMatrix1D.copy();
        this.r = doubleMatrix1D.copy();
        this.ztilde = doubleMatrix1D.copy();
        this.ptilde = doubleMatrix1D.copy();
        this.qtilde = doubleMatrix1D.copy();
        this.rtilde = doubleMatrix1D.copy();
    }

    public DoubleMatrix1D solve(DoubleMatrix2D doubleMatrix2D, DoubleMatrix1D doubleMatrix1D, DoubleMatrix1D doubleMatrix1D2) throws IterativeSolverDoubleNotConvergedException {
        this.checkSizes(doubleMatrix2D, doubleMatrix1D, doubleMatrix1D2);
        double d = 1.0;
        double d2 = 1.0;
        double d3 = 1.0;
        double d4 = 1.0;
        doubleMatrix2D.zMult(doubleMatrix1D2, this.r.assign(doubleMatrix1D), -1.0, 1.0, false);
        this.rtilde.assign(this.r);
        this.iter.setFirst();
        while (!this.iter.converged(this.r, doubleMatrix1D2)) {
            this.M.apply(this.r, this.z);
            this.M.transApply(this.rtilde, this.ztilde);
            d = this.z.zDotProduct(this.rtilde);
            if (d == 0.0) {
                throw new IterativeSolverDoubleNotConvergedException(DoubleNotConvergedException.Reason.Breakdown, "rho", this.iter);
            }
            if (this.iter.isFirst()) {
                this.p.assign(this.z);
                this.ptilde.assign(this.ztilde);
            } else {
                d4 = d / d2;
                this.p.assign(this.z, DoubleFunctions.plusMultFirst(d4));
                this.ptilde.assign(this.ztilde, DoubleFunctions.plusMultFirst(d4));
            }
            doubleMatrix2D.zMult(this.p, this.q);
            doubleMatrix2D.zMult(this.ptilde, this.qtilde, 1.0, 0.0, true);
            d3 = d / this.ptilde.zDotProduct(this.q);
            doubleMatrix1D2.assign(this.p, DoubleFunctions.plusMultSecond(d3));
            this.r.assign(this.q, DoubleFunctions.plusMultSecond(-d3));
            this.rtilde.assign(this.qtilde, DoubleFunctions.plusMultSecond(-d3));
            d2 = d;
            this.iter.next();
        }
        return doubleMatrix1D2;
    }
}

