/*
 * Decompiled with CFR 0.152.
 */
package dr.evolution.coalescent;

import dr.evolution.coalescent.ExponentialGrowth;
import dr.evolution.util.Units;

public class ExpConstant
extends ExponentialGrowth {
    private double transitionTime;

    public ExpConstant(Units.Type type) {
        super(type);
    }

    public double getTransitionTime() {
        return this.transitionTime;
    }

    public void setTransitionTime(double d) {
        this.transitionTime = d;
    }

    @Override
    public double getDemographic(double d) {
        double d2 = this.getN0();
        double d3 = this.getGrowthRate();
        double d4 = this.getTransitionTime();
        if (d < d4) {
            return d2 * Math.exp(-d3 * d4);
        }
        return d2 * Math.exp(-d3 * d);
    }

    @Override
    public double getIntensity(double d) {
        double d2 = this.getN0();
        double d3 = this.getGrowthRate();
        double d4 = this.getTransitionTime();
        double d5 = d2 * Math.exp(-d3 * d4);
        if (d3 == 0.0) {
            return d / this.getN0();
        }
        if (d == 0.0) {
            return 0.0;
        }
        if (d4 <= 0.0) {
            if (d >= d4) {
                return super.getIntensity(d);
            }
            return 1.0 / (d2 * d3) * (Math.exp(d3 * d4) - 1.0) + (d - d4) / d5;
        }
        if (d <= d4) {
            return d / d5;
        }
        return d4 / d5 + 1.0 / (d2 * d3) * (Math.exp(d3 * d) - Math.exp(d3 * d4));
    }

    @Override
    public double getInverseIntensity(double d) {
        double d2 = this.getN0();
        double d3 = this.getGrowthRate();
        double d4 = this.getTransitionTime();
        double d5 = d2 * Math.exp(-d3 * d4);
        if (d3 == 0.0) {
            return this.getN0() * d;
        }
        if (d4 <= 0.0) {
            if (d > 1.0 / (d2 * d3) * (Math.exp(d3 * d4) - 1.0)) {
                return super.getInverseIntensity(d);
            }
            return Math.exp(-d3 * d4) * (d2 * d - (Math.exp(d3 * d4) - 1.0) / d3) + d4;
        }
        if (d < d4 / d5) {
            return d5 * d;
        }
        return Math.log(d3 * (d2 * d - d4 * Math.exp(d3 * d4)) + Math.exp(d3 * d4)) / d3;
    }

    @Override
    public int getNumArguments() {
        return 3;
    }

    @Override
    public String getArgumentName(int n) {
        switch (n) {
            case 0: {
                return "N0";
            }
            case 1: {
                return "r";
            }
            case 2: {
                return "transitionTime";
            }
        }
        throw new IllegalArgumentException("Argument " + n + " does not exist");
    }

    @Override
    public double getArgument(int n) {
        switch (n) {
            case 0: {
                return this.getN0();
            }
            case 1: {
                return this.getGrowthRate();
            }
            case 2: {
                return this.getTransitionTime();
            }
        }
        throw new IllegalArgumentException("Argument " + n + " does not exist");
    }

    @Override
    public void setArgument(int n, double d) {
        switch (n) {
            case 0: {
                this.setN0(d);
                break;
            }
            case 1: {
                this.setGrowthRate(d);
                break;
            }
            case 2: {
                this.setTransitionTime(d);
                break;
            }
            default: {
                throw new IllegalArgumentException("Argument " + n + " does not exist");
            }
        }
    }

    @Override
    public double getLowerBound(int n) {
        switch (n) {
            case 0: {
                return 0.0;
            }
            case 1: {
                return 0.0;
            }
            case 2: {
                return Double.NEGATIVE_INFINITY;
            }
        }
        throw new IllegalArgumentException("Argument " + n + " does not exist");
    }

    @Override
    public double getUpperBound(int n) {
        return Double.POSITIVE_INFINITY;
    }
}

