/*
 * Decompiled with CFR 0.152.
 */
package jdplus.tramoseats.base.r;

import com.google.protobuf.InvalidProtocolBufferException;
import jdplus.sa.base.api.EstimationPolicyType;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.math.matrices.Matrix;
import jdplus.toolkit.base.api.timeseries.TsData;
import jdplus.toolkit.base.api.timeseries.TsDomain;
import jdplus.toolkit.base.api.timeseries.regression.ModellingContext;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.modelling.StationaryTransformation;
import jdplus.toolkit.base.core.regsarima.regular.Forecast;
import jdplus.toolkit.base.core.regsarima.regular.RegSarimaModel;
import jdplus.toolkit.base.core.regsarima.regular.RegSarimaProcessor;
import jdplus.toolkit.base.protobuf.regarima.RegArimaEstimationProto;
import jdplus.tramoseats.base.api.tramo.TramoSpec;
import jdplus.tramoseats.base.core.tramo.TramoFactory;
import jdplus.tramoseats.base.core.tramo.TramoKernel;
import jdplus.tramoseats.base.core.tramo.TramoOutput;
import jdplus.tramoseats.base.core.tramo.internal.DifferencingModule;
import jdplus.tramoseats.base.protobuf.TramoProto;
import lombok.Generated;

public final class Tramo {
    public static byte[] toBuffer(RegSarimaModel core) {
        return RegArimaEstimationProto.convert((RegSarimaModel)core).toByteArray();
    }

    public static RegSarimaModel process(TsData series, String defSpec) {
        TramoSpec spec = TramoSpec.fromString((String)defSpec);
        TramoKernel tramo = TramoKernel.of((TramoSpec)spec, null);
        return tramo.process(series.cleanExtremities(), null);
    }

    public static RegSarimaModel process(TsData series, TramoSpec spec, ModellingContext context) {
        TramoKernel tramo = TramoKernel.of((TramoSpec)spec, (ModellingContext)context);
        return tramo.process(series.cleanExtremities(), null);
    }

    public static TramoSpec refreshSpec(TramoSpec currentSpec, TramoSpec domainSpec, TsDomain domain, String policy) {
        return TramoFactory.getInstance().refreshSpec(currentSpec, domainSpec, EstimationPolicyType.valueOf((String)policy), domain);
    }

    public static Matrix forecast(TsData series, String defSpec, int nf) {
        TramoSpec spec = TramoSpec.fromString((String)defSpec);
        return Tramo.forecast(series, spec, null, nf);
    }

    public static Matrix forecast(TsData series, TramoSpec spec, ModellingContext context, int nf) {
        TramoKernel kernel = TramoKernel.of((TramoSpec)spec, (ModellingContext)context);
        Forecast f = new Forecast((RegSarimaProcessor)kernel, nf);
        if (!f.process(series.cleanExtremities())) {
            return null;
        }
        FastMatrix R = FastMatrix.make((int)nf, (int)4);
        R.column(0).copy(f.getForecasts());
        R.column(1).copy(f.getForecastsStdev());
        R.column(2).copy(f.getRawForecasts());
        R.column(3).copy(f.getRawForecastsStdev());
        return R;
    }

    public static TramoOutput fullProcess(TsData series, TramoSpec spec, ModellingContext context) {
        TramoKernel tramo = TramoKernel.of((TramoSpec)spec, (ModellingContext)context);
        RegSarimaModel estimation = tramo.process(series.cleanExtremities(), null);
        return TramoOutput.builder().estimationSpec(spec).result(estimation).resultSpec(estimation == null ? null : TramoFactory.getInstance().generateSpec(spec, estimation.getDescription())).build();
    }

    public static TramoOutput fullProcess(TsData series, String defSpec) {
        TramoSpec spec = TramoSpec.fromString((String)defSpec);
        return Tramo.fullProcess(series, spec, null);
    }

    public static byte[] toBuffer(TramoSpec spec) {
        return TramoProto.convert((TramoSpec)spec).toByteArray();
    }

    public static TramoSpec specOf(byte[] buffer) {
        try {
            jdplus.tramoseats.base.protobuf.TramoSpec spec = jdplus.tramoseats.base.protobuf.TramoSpec.parseFrom((byte[])buffer);
            return TramoProto.convert((jdplus.tramoseats.base.protobuf.TramoSpec)spec);
        }
        catch (InvalidProtocolBufferException ex) {
            return null;
        }
    }

    public static byte[] toBuffer(TramoOutput output) {
        return TramoProto.convert((TramoOutput)output).toByteArray();
    }

    public static StationaryTransformation doStationary(double[] data, int period) {
        DifferencingModule diff = DifferencingModule.builder().build();
        DoubleSeq s = DoubleSeq.of((double[])data);
        diff.process(s, period, 0, 0, true);
        return StationaryTransformation.builder().meanCorrection(diff.isMeanCorrection()).difference(new StationaryTransformation.Differencing(1, diff.getD())).difference(new StationaryTransformation.Differencing(period, diff.getBd())).build();
    }

    @Generated
    private Tramo() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

