/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.ssf.likelihood;

import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.core.math.functions.IParametersDomain;
import jdplus.toolkit.base.core.math.functions.IParametricMapping;
import jdplus.toolkit.base.core.ssf.likelihood.AugmentedLikelihoodFunctionPoint;
import jdplus.toolkit.base.core.ssf.likelihood.DiffuseLikelihood;
import jdplus.toolkit.base.core.ssf.univariate.ISsf;
import jdplus.toolkit.base.core.ssf.univariate.ISsfBuilder;
import jdplus.toolkit.base.core.ssf.univariate.ISsfData;
import jdplus.toolkit.base.core.stats.likelihood.LikelihoodFunction;

public class AugmentedLikelihoodFunction<S, F extends ISsf>
implements LikelihoodFunction<DiffuseLikelihood> {
    private final IParametricMapping<S> mapping;
    private final ISsfBuilder<S, F> builder;
    private final ISsfData data;
    private final boolean missing;
    private final boolean ml;
    private final boolean log;
    private final boolean fast;
    private final boolean mt;
    private final boolean sym;
    private final boolean scaling;
    private final boolean res;
    private final boolean collapsing;
    private final boolean robust;

    public static <S, F extends ISsf> Builder builder(ISsfData data, IParametricMapping<S> mapping, ISsfBuilder<S, F> builder) {
        return new Builder<S, F>(data, mapping, builder);
    }

    private AugmentedLikelihoodFunction(ISsfData data, IParametricMapping<S> mapper, ISsfBuilder<S, F> builder, boolean ml, boolean log, boolean fast, boolean mt, boolean sym, boolean scaling, boolean res, boolean collapsing, boolean robust) {
        this.data = data;
        this.mapping = mapper;
        this.builder = builder;
        this.missing = data.hasMissingValues();
        this.ml = ml;
        this.fast = fast;
        this.log = log;
        this.mt = mt;
        this.sym = sym;
        this.scaling = scaling;
        this.res = res;
        this.collapsing = collapsing;
        this.robust = robust;
    }

    public IParametricMapping<S> getMapping() {
        return this.mapping;
    }

    public boolean isMaximumLikelihood() {
        return this.ml;
    }

    public boolean isLog() {
        return this.log;
    }

    public boolean isFast() {
        return this.fast;
    }

    public boolean isScalingFactor() {
        return this.scaling;
    }

    public boolean isResiduals() {
        return this.res;
    }

    public boolean isCollapsing() {
        return this.collapsing;
    }

    public boolean isRobust() {
        return this.robust;
    }

    @Override
    public AugmentedLikelihoodFunctionPoint<S, F> evaluate(DoubleSeq parameters) {
        return new AugmentedLikelihoodFunctionPoint(this, parameters);
    }

    @Override
    public IParametersDomain getDomain() {
        return this.mapping;
    }

    @Override
    public AugmentedLikelihoodFunctionPoint<S, F> ssqEvaluate(DoubleSeq parameters) {
        return new AugmentedLikelihoodFunctionPoint(this, parameters);
    }

    public ISsfBuilder<S, F> getBuilder() {
        return this.builder;
    }

    public ISsfData getData() {
        return this.data;
    }

    public boolean isMissing() {
        return this.missing;
    }

    public boolean isMl() {
        return this.ml;
    }

    public boolean isMultiThreaded() {
        return this.mt;
    }

    public boolean isSymmetric() {
        return this.sym;
    }

    public static class Builder<S, F extends ISsf> {
        private final IParametricMapping<S> mapping;
        private final ISsfBuilder<S, F> builder;
        private final ISsfData data;
        private boolean ml = true;
        private boolean log = false;
        private boolean fast = false;
        private boolean mt = false;
        private boolean sym = false;
        private boolean scalingFactor = true;
        private boolean res = true;
        private boolean collapsing = true;
        private boolean robust = false;

        private Builder(ISsfData data, IParametricMapping<S> mapping, ISsfBuilder<S, F> builder) {
            this.data = data;
            this.builder = builder;
            this.mapping = mapping;
        }

        public Builder useParallelProcessing(boolean mt) {
            this.mt = mt;
            return this;
        }

        public Builder useMaximumLikelihood(boolean ml) {
            this.ml = ml;
            return this;
        }

        public Builder useLog(boolean log) {
            this.log = log;
            return this;
        }

        public Builder useFastAlgorithm(boolean fast) {
            this.fast = fast;
            return this;
        }

        public Builder useSymmetricNumericalDerivatives(boolean sym) {
            this.sym = sym;
            return this;
        }

        public Builder useScalingFactor(boolean scalingFactor) {
            this.scalingFactor = scalingFactor;
            if (!scalingFactor) {
                this.log = true;
            } else {
                this.res = true;
            }
            return this;
        }

        public Builder useCollapsing(boolean collapsing) {
            this.collapsing = collapsing;
            if (collapsing) {
                this.robust = false;
            }
            return this;
        }

        public Builder robust(boolean robust) {
            this.robust = robust;
            if (robust) {
                this.collapsing = false;
            }
            return this;
        }

        public Builder residuals(boolean res) {
            this.res = res;
            return this;
        }

        public AugmentedLikelihoodFunction<S, F> build() {
            return new AugmentedLikelihoodFunction<S, F>(this.data, this.mapping, this.builder, this.ml, this.log, this.fast, this.mt, this.sym, this.scalingFactor, this.res, this.collapsing, this.robust);
        }
    }
}

