/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.regarima.tests;

import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.stats.StatisticalTest;
import jdplus.toolkit.base.api.stats.TestType;
import jdplus.toolkit.base.core.arima.IArimaModel;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.dstats.F;
import jdplus.toolkit.base.core.regarima.IRegArimaComputer;
import jdplus.toolkit.base.core.regarima.RegArimaEstimation;
import jdplus.toolkit.base.core.regarima.RegArimaModel;
import jdplus.toolkit.base.core.regarima.RegArimaUtility;
import jdplus.toolkit.base.core.regarima.estimation.ConcentratedLikelihoodComputer;
import jdplus.toolkit.base.core.stats.likelihood.ConcentratedLikelihoodWithMissing;
import jdplus.toolkit.base.core.stats.tests.SampleMean;
import jdplus.toolkit.base.core.stats.tests.TestsUtility;
import lombok.Generated;

public class OneStepAheadForecastingTest {
    private final DoubleSeq residuals;
    private final double meanIn;
    private final double meanOut;
    private final double varIn;
    private final double varOut;
    private final int outSampleSize;
    private final int inSampleSize;
    private final boolean mean;

    public static <M extends IArimaModel> OneStepAheadForecastingTest of(RegArimaModel<M> regarima, IRegArimaComputer<M> processor, int nback) {
        try {
            RegArimaModel<M> model = OneStepAheadForecastingTest.linearize(regarima);
            DoubleSeq residuals = OneStepAheadForecastingTest.computeResiduals(model, processor, nback);
            if (residuals == null) {
                return null;
            }
            int n = residuals.length();
            if (n <= nback * 2) {
                return null;
            }
            DoubleSeq in = residuals.drop(0, nback);
            DoubleSeq out = residuals.range(in.length(), n);
            boolean mean = regarima.isMean();
            int inSampleSize = mean ? in.length() - 1 : in.length();
            double meanIn = in.sum() / (double)in.length();
            double varIn = in.ssq() / (double)inSampleSize;
            double meanOut = out.sum() / (double)nback;
            double varOut = out.ssq() / (double)nback;
            return new OneStepAheadForecastingTest(residuals, meanIn, meanOut, varIn, varOut, nback, inSampleSize, mean);
        }
        catch (Exception err) {
            return null;
        }
    }

    public int getOutOfSampleLength() {
        return this.outSampleSize;
    }

    public int getInSampleLength() {
        return this.residuals.length() - this.outSampleSize;
    }

    public StatisticalTest outOfSampleMeanTest() {
        return new SampleMean(this.meanOut, this.outSampleSize).populationMean(0.0).estimatedPopulationVariance(this.varIn, this.inSampleSize).normalDistribution(true).build();
    }

    public DoubleSeq getInSampleResiduals() {
        return this.residuals.drop(0, this.outSampleSize);
    }

    public double getInSampleMean() {
        return this.meanIn;
    }

    public double getOutOfSampleMean() {
        return this.meanOut;
    }

    public double getInSampleMeanSquaredError() {
        return Math.sqrt(this.varIn);
    }

    public double getOutOfSampleMeanSquaredError() {
        return Math.sqrt(this.varOut);
    }

    public DoubleSeq getOutOfSampleResiduals() {
        int n = this.residuals.length();
        return this.residuals.range(n - this.outSampleSize, n);
    }

    public StatisticalTest sameVarianceTest() {
        F f = new F(this.outSampleSize, this.inSampleSize);
        return TestsUtility.testOf(this.varOut / this.varIn, f, TestType.Upper);
    }

    public StatisticalTest inSampleMeanTest() {
        int n = this.residuals.length();
        int nsample = n - this.outSampleSize;
        return new SampleMean(this.meanIn, nsample).populationMean(0.0).estimatedPopulationVariance(this.varIn, this.inSampleSize).normalDistribution(true).build();
    }

    private static <M extends IArimaModel> RegArimaModel<M> linearize(RegArimaModel<M> regarima) {
        if (regarima.getVariablesCount() == 0) {
            return regarima;
        }
        ConcentratedLikelihoodWithMissing concentratedLikelihood = ConcentratedLikelihoodComputer.DEFAULT_COMPUTER.compute(regarima);
        DoubleSeq linearizedData = RegArimaUtility.linearizedData(regarima, concentratedLikelihood);
        return RegArimaModel.builder().y(linearizedData).arima(regarima.arima()).meanCorrection(regarima.isMean()).build();
    }

    private static <M extends IArimaModel> RegArimaEstimation inSampleEstimate(RegArimaModel<M> regarima, IRegArimaComputer<M> processor, int nback) {
        if (regarima.getObservationsCount() <= nback) {
            return null;
        }
        M arima = regarima.arima();
        RegArimaModel model = RegArimaModel.builder().y(regarima.getY().drop(0, nback)).arima(arima).meanCorrection(regarima.isMean()).build();
        return processor.optimize(model, null);
    }

    private static <M extends IArimaModel> DoubleSeq computeResiduals(RegArimaModel<M> regarima, IRegArimaComputer<M> processor, int nback) {
        try {
            RegArimaEstimation est = OneStepAheadForecastingTest.inSampleEstimate(regarima, processor, nback);
            if (est == null) {
                return null;
            }
            Object y = regarima.getY();
            if (regarima.isMean()) {
                DataBlock yc = DataBlock.of(regarima.getY());
                double[] m = RegArimaUtility.meanRegressionVariable(regarima.arima().getNonStationaryAr(), yc.length());
                yc.addAY(-est.getConcentratedLikelihood().coefficient(0), DataBlock.of(m));
                y = yc;
            }
            RegArimaModel model = RegArimaModel.builder().y((DoubleSeq)y).arima(est.getModel().arima()).build();
            return ConcentratedLikelihoodComputer.DEFAULT_COMPUTER.compute(model).e();
        }
        catch (Exception err) {
            return null;
        }
    }

    @Generated
    private OneStepAheadForecastingTest(DoubleSeq residuals, double meanIn, double meanOut, double varIn, double varOut, int outSampleSize, int inSampleSize, boolean mean) {
        this.residuals = residuals;
        this.meanIn = meanIn;
        this.meanOut = meanOut;
        this.varIn = varIn;
        this.varOut = varOut;
        this.outSampleSize = outSampleSize;
        this.inSampleSize = inSampleSize;
        this.mean = mean;
    }
}

