/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.modelling.extractors;

import jdplus.toolkit.base.api.information.InformationMapping;
import jdplus.toolkit.base.core.sarima.SarimaModel;

public class SarimaExtractor
extends InformationMapping<SarimaModel> {
    public SarimaExtractor() {
        this.set("p", Integer.class, source -> source.getP());
        this.set("d", Integer.class, source -> source.getD());
        this.set("q", Integer.class, source -> source.getQ());
        this.set("bp", Integer.class, source -> source.getBp());
        this.set("bd", Integer.class, source -> source.getBd());
        this.set("bq", Integer.class, source -> source.getBq());
        this.set("phi", double[].class, source -> source.getPhi().toArray());
        this.set("bphi", double[].class, source -> source.getBphi().toArray());
        this.set("theta", double[].class, source -> source.getTheta().toArray());
        this.set("btheta", double[].class, source -> source.getBtheta().toArray());
        this.setArray("phi", 1, 12, Double.class, (source, i) -> {
            if (i <= 0 || i > source.getP()) {
                return null;
            }
            return source.phi((int)i);
        });
        this.setArray("bphi", 1, 2, Double.class, (source, i) -> {
            if (i <= 0 || i > source.getBp()) {
                return null;
            }
            return source.bphi((int)i);
        });
        this.setArray("theta", 1, 12, Double.class, (source, i) -> {
            if (i <= 0 || i > source.getQ()) {
                return null;
            }
            return source.theta((int)i);
        });
        this.setArray("btheta", 1, 2, Double.class, (source, i) -> {
            if (i <= 0 || i > source.getBq()) {
                return null;
            }
            return source.btheta((int)i);
        });
    }

    public Class<SarimaModel> getSourceClass() {
        return SarimaModel.class;
    }
}

