/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.data.analysis;

import java.util.Arrays;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.data.DoubleSeqCursor;
import jdplus.toolkit.base.api.util.IntList;
import lombok.Generated;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public final class Periodogram {
    private final double[] p;
    private final int n;

    public static Periodogram of(DoubleSeq y) {
        int i;
        int T2 = y.length();
        int T1 = (1 + T2) / 2;
        int T22 = 1 + T2 / 2;
        double sy = 0.0;
        double sy2 = 0.0;
        DoubleSeqCursor reader = y.cursor();
        int n = 0;
        for (int i2 = 0; i2 < T2; ++i2) {
            double cur = reader.getAndNext();
            if (Double.isNaN(cur)) continue;
            ++n;
            sy += cur;
            sy2 += cur * cur;
        }
        double[] p = new double[T22];
        double l = Math.PI * 2 / (double)T2;
        double cosl = Math.cos(l);
        double sinl = Math.sin(l);
        double cos = 1.0;
        double sin = 0.0;
        p[0] = sy * sy / sy2;
        double a = 0.0;
        double b = 0.0;
        for (i = 1; i < T1; ++i) {
            double ctmp = cos;
            double stmp = sin;
            sin = cosl * stmp + sinl * ctmp;
            cos = -sinl * stmp + cosl * ctmp;
            a = 0.0;
            b = 0.0;
            double c = 1.0;
            double s = 0.0;
            reader.moveTo(0);
            for (int j = 0; j < T2; ++j) {
                ctmp = c;
                stmp = s;
                s = cos * stmp + sin * ctmp;
                c = -sin * stmp + cos * ctmp;
                double cur = reader.getAndNext();
                if (Double.isNaN(cur)) continue;
                a += c * cur;
                b += s * cur;
            }
            p[i] = 2.0 * (a * a + b * b) / sy2;
        }
        if (T1 != T22) {
            a = 0.0;
            reader.moveTo(0);
            for (i = 0; i < T2; ++i) {
                double cur = reader.getAndNext();
                if (Double.isNaN(cur)) continue;
                if (i % 2 == 0) {
                    a += cur;
                    continue;
                }
                a -= cur;
            }
            p[T22 - 1] = a * a / sy2;
        }
        return new Periodogram(p, n);
    }

    private Periodogram(double[] p, int n) {
        this.p = p;
        this.n = n;
    }

    public static double[] getSeasonalFrequencies(int freq) {
        double[] dfreq = new double[freq / 2];
        for (int i = 1; i <= dfreq.length; ++i) {
            dfreq[i - 1] = Math.PI * 2 * (double)i / (double)freq;
        }
        return dfreq;
    }

    public static double[] getTradingDaysFrequencies(int freq) {
        double n = 365.25 / (double)freq;
        double f = 0.8975979010256552 * (n - 7.0 * Math.floor(n / 7.0));
        if (f > Math.PI) {
            f = Math.PI * 2 - f;
        }
        if (freq == 12) {
            return new double[]{f};
        }
        if (freq == 4) {
            return new double[]{f, 1.292, 1.85, 2.128};
        }
        return new double[]{f};
    }

    public double getIntervalInRadians() {
        return Math.PI * 2 / (double)(this.n - 1);
    }

    public int[] searchPeaks(double dMin, boolean smoothed) {
        IntList peaks = new IntList(this.p.length);
        for (int i = 0; i < this.p.length; ++i) {
            if (!(this.p[i] > dMin)) continue;
            peaks.add(i);
        }
        return peaks.toArray();
    }

    @Generated
    public double[] getP() {
        return this.p;
    }

    @Generated
    public int getN() {
        return this.n;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Periodogram)) {
            return false;
        }
        Periodogram other = (Periodogram)o;
        if (this.getN() != other.getN()) {
            return false;
        }
        return Arrays.equals(this.getP(), other.getP());
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getN();
        result = result * 59 + Arrays.hashCode(this.getP());
        return result;
    }

    @Generated
    public @NonNull String toString() {
        return "Periodogram(p=" + Arrays.toString(this.getP()) + ", n=" + this.getN() + ")";
    }
}

