/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.r.arima;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import jdplus.toolkit.base.api.arima.SarimaOrders;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.data.Doubles;
import jdplus.toolkit.base.api.information.GenericExplorable;
import jdplus.toolkit.base.api.information.InformationMapping;
import jdplus.toolkit.base.api.math.matrices.Matrix;
import jdplus.toolkit.base.api.util.IntList;
import jdplus.toolkit.base.core.arima.IArimaModel;
import jdplus.toolkit.base.core.data.interpolation.AverageInterpolator;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.regarima.RegArimaEstimation;
import jdplus.toolkit.base.core.regarima.RegArimaModel;
import jdplus.toolkit.base.core.regsarima.RegSarimaComputer;
import jdplus.toolkit.base.core.sarima.SarimaModel;
import jdplus.toolkit.base.core.stats.likelihood.ConcentratedLikelihoodWithMissing;
import jdplus.toolkit.base.core.stats.likelihood.LikelihoodStatistics;
import lombok.Generated;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class ArimaEstimation {
    private double[] phi;
    private double[] theta;
    private double[] bphi;
    private double[] btheta;
    private int[] order;
    private int[] seasonalOrder;
    private int period;
    private double[] y;
    private final List<double[]> xreg = new ArrayList<double[]>();
    private boolean mean;

    public void addX(double[] x) {
        this.xreg.add(x);
    }

    public Results process() {
        SarimaOrders spec = new SarimaOrders(this.period);
        if (this.order != null) {
            spec.setP(this.order[0]);
            spec.setD(this.order[1]);
            spec.setQ(this.order[2]);
        }
        if (this.seasonalOrder != null) {
            spec.setBp(this.seasonalOrder[0]);
            spec.setBd(this.seasonalOrder[1]);
            spec.setBq(this.seasonalOrder[2]);
        }
        SarimaModel.Builder builder = SarimaModel.builder((SarimaOrders)spec);
        SarimaModel arima = builder.setDefault().build();
        RegSarimaComputer monitor = RegSarimaComputer.builder().useParallelProcessing(true).useMaximumLikelihood(true).useCorrectedDegreesOfFreedom(false).precision(1.0E-12).startingPoint(RegSarimaComputer.StartingPoint.Multiple).computeExactFinalDerivatives(true).build();
        IntList missings = new IntList();
        AverageInterpolator.cleanMissings((double[])this.y, (IntList)missings);
        RegArimaModel.Builder rbuilder = RegArimaModel.builder().y((DoubleSeq)Doubles.of((double[])this.y)).arima((IArimaModel)arima).meanCorrection(this.mean).missing(missings.toArray());
        for (double[] x : this.xreg) {
            rbuilder.addX(DoubleSeq.of((double[])x));
        }
        RegArimaEstimation rslt = monitor.process(rbuilder.build(), null);
        return new Results((RegArimaModel<SarimaModel>)rslt.getModel(), rslt.getConcentratedLikelihood(), rslt.statistics(), rslt.getMax().asymptoticCovariance(), rslt.getMax().getScore());
    }

    @Generated
    public double[] getPhi() {
        return this.phi;
    }

    @Generated
    public double[] getTheta() {
        return this.theta;
    }

    @Generated
    public double[] getBphi() {
        return this.bphi;
    }

    @Generated
    public double[] getBtheta() {
        return this.btheta;
    }

    @Generated
    public int[] getOrder() {
        return this.order;
    }

    @Generated
    public int[] getSeasonalOrder() {
        return this.seasonalOrder;
    }

    @Generated
    public int getPeriod() {
        return this.period;
    }

    @Generated
    public double[] getY() {
        return this.y;
    }

    @Generated
    public List<double[]> getXreg() {
        return this.xreg;
    }

    @Generated
    public boolean isMean() {
        return this.mean;
    }

    @Generated
    public void setPhi(double[] phi) {
        this.phi = phi;
    }

    @Generated
    public void setTheta(double[] theta) {
        this.theta = theta;
    }

    @Generated
    public void setBphi(double[] bphi) {
        this.bphi = bphi;
    }

    @Generated
    public void setBtheta(double[] btheta) {
        this.btheta = btheta;
    }

    @Generated
    public void setOrder(int[] order) {
        this.order = order;
    }

    @Generated
    public void setSeasonalOrder(int[] seasonalOrder) {
        this.seasonalOrder = seasonalOrder;
    }

    @Generated
    public void setPeriod(int period) {
        this.period = period;
    }

    @Generated
    public void setY(double[] y) {
        this.y = y;
    }

    @Generated
    public void setMean(boolean mean) {
        this.mean = mean;
    }

    public static final class Results
    implements GenericExplorable {
        private final RegArimaModel<SarimaModel> regarima;
        private final ConcentratedLikelihoodWithMissing concentratedLogLikelihood;
        private final LikelihoodStatistics statistics;
        private final FastMatrix parametersCovariance;
        private final DoubleSeq score;
        private static final String ARIMA = "sarima";
        private static final String LL = "likelihood";
        private static final String PCOV = "pcov";
        private static final String SCORE = "score";
        private static final String B = "b";
        private static final String UNSCALEDBVAR = "unscaledbvar";
        private static final String MEAN = "mean";
        private static final InformationMapping<Results> MAPPING = new InformationMapping<Results>(){

            public Class getSourceClass() {
                return Results.class;
            }
        };

        public SarimaModel getArima() {
            return (SarimaModel)this.regarima.arima();
        }

        public boolean contains(String id) {
            return MAPPING.contains(id);
        }

        public Map<String, Class> getDictionary() {
            LinkedHashMap<String, Class> dic = new LinkedHashMap<String, Class>();
            MAPPING.fillDictionary(null, dic, true);
            return dic;
        }

        public <T> T getData(String id, Class<T> tclass) {
            return (T)MAPPING.getData((Object)this, id, tclass);
        }

        public static final InformationMapping<Results> getMapping() {
            return MAPPING;
        }

        @Generated
        public Results(RegArimaModel<SarimaModel> regarima, ConcentratedLikelihoodWithMissing concentratedLogLikelihood, LikelihoodStatistics statistics, FastMatrix parametersCovariance, DoubleSeq score) {
            this.regarima = regarima;
            this.concentratedLogLikelihood = concentratedLogLikelihood;
            this.statistics = statistics;
            this.parametersCovariance = parametersCovariance;
            this.score = score;
        }

        @Generated
        public RegArimaModel<SarimaModel> getRegarima() {
            return this.regarima;
        }

        @Generated
        public ConcentratedLikelihoodWithMissing getConcentratedLogLikelihood() {
            return this.concentratedLogLikelihood;
        }

        @Generated
        public LikelihoodStatistics getStatistics() {
            return this.statistics;
        }

        @Generated
        public FastMatrix getParametersCovariance() {
            return this.parametersCovariance;
        }

        @Generated
        public DoubleSeq getScore() {
            return this.score;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Results)) {
                return false;
            }
            Results other = (Results)o;
            RegArimaModel<SarimaModel> this$regarima = this.getRegarima();
            RegArimaModel<SarimaModel> other$regarima = other.getRegarima();
            if (this$regarima == null ? other$regarima != null : !this$regarima.equals(other$regarima)) {
                return false;
            }
            ConcentratedLikelihoodWithMissing this$concentratedLogLikelihood = this.getConcentratedLogLikelihood();
            ConcentratedLikelihoodWithMissing other$concentratedLogLikelihood = other.getConcentratedLogLikelihood();
            if (this$concentratedLogLikelihood == null ? other$concentratedLogLikelihood != null : !this$concentratedLogLikelihood.equals(other$concentratedLogLikelihood)) {
                return false;
            }
            LikelihoodStatistics this$statistics = this.getStatistics();
            LikelihoodStatistics other$statistics = other.getStatistics();
            if (this$statistics == null ? other$statistics != null : !this$statistics.equals(other$statistics)) {
                return false;
            }
            FastMatrix this$parametersCovariance = this.getParametersCovariance();
            FastMatrix other$parametersCovariance = other.getParametersCovariance();
            if (this$parametersCovariance == null ? other$parametersCovariance != null : !this$parametersCovariance.equals(other$parametersCovariance)) {
                return false;
            }
            DoubleSeq this$score = this.getScore();
            DoubleSeq other$score = other.getScore();
            return !(this$score == null ? other$score != null : !this$score.equals(other$score));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            RegArimaModel<SarimaModel> $regarima = this.getRegarima();
            result = result * 59 + ($regarima == null ? 43 : $regarima.hashCode());
            ConcentratedLikelihoodWithMissing $concentratedLogLikelihood = this.getConcentratedLogLikelihood();
            result = result * 59 + ($concentratedLogLikelihood == null ? 43 : $concentratedLogLikelihood.hashCode());
            LikelihoodStatistics $statistics = this.getStatistics();
            result = result * 59 + ($statistics == null ? 43 : $statistics.hashCode());
            FastMatrix $parametersCovariance = this.getParametersCovariance();
            result = result * 59 + ($parametersCovariance == null ? 43 : $parametersCovariance.hashCode());
            DoubleSeq $score = this.getScore();
            result = result * 59 + ($score == null ? 43 : $score.hashCode());
            return result;
        }

        @Generated
        public @NonNull String toString() {
            return "ArimaEstimation.Results(regarima=" + String.valueOf(this.getRegarima()) + ", concentratedLogLikelihood=" + String.valueOf(this.getConcentratedLogLikelihood()) + ", statistics=" + String.valueOf(this.getStatistics()) + ", parametersCovariance=" + String.valueOf(this.getParametersCovariance()) + ", score=" + String.valueOf(this.getScore()) + ")";
        }

        static {
            MAPPING.delegate(ARIMA, SarimaModel.class, r -> r.getArima());
            MAPPING.delegate(LL, LikelihoodStatistics.class, r -> r.statistics);
            MAPPING.set(PCOV, Matrix.class, source -> source.getParametersCovariance());
            MAPPING.set(SCORE, double[].class, source -> source.getScore().toArray());
            MAPPING.set(B, double[].class, source -> {
                DoubleSeq b = source.getConcentratedLogLikelihood().coefficients();
                return b.toArray();
            });
            MAPPING.set(MEAN, Double.class, source -> {
                if (source.getRegarima().isMean()) {
                    DoubleSeq b = source.getConcentratedLogLikelihood().coefficients();
                    int mpos = source.getRegarima().getMissingValuesCount();
                    return b.get(mpos);
                }
                return 0.0;
            });
            MAPPING.set(UNSCALEDBVAR, Matrix.class, source -> source.getConcentratedLogLikelihood().unscaledCovariance());
        }
    }
}

