/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.api.util;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.function.Function;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import lombok.Generated;
import lombok.NonNull;

public final class TreeTraverser<T> {
    @NonNull
    private final T root;
    @NonNull
    private final Function<? super T, ? extends Iterable<? extends T>> children;

    @NonNull
    public static <Z> TreeTraverser<Z> of(@NonNull Z root, @NonNull Function<? super Z, ? extends Iterable<? extends Z>> children) {
        if (root == null) {
            throw new NullPointerException("root is marked non-null but is null");
        }
        if (children == null) {
            throw new NullPointerException("children is marked non-null but is null");
        }
        return new TreeTraverser<Z>(root, children);
    }

    @NonNull
    public Iterable<T> breadthFirstIterable() {
        return () -> new BreadthFirstIterator<T>(this.root, this.children);
    }

    @NonNull
    public Stream<T> breadthFirstStream() {
        return StreamSupport.stream(this.breadthFirstIterable().spliterator(), false);
    }

    @NonNull
    public Iterable<T> depthFirstIterable() {
        return () -> new DepthFirstIterator<T>(this.root, this.children);
    }

    @NonNull
    public Stream<T> depthFirstStream() {
        return StreamSupport.stream(this.depthFirstIterable().spliterator(), false);
    }

    @NonNull
    public String prettyPrintToString(int maxLevel, @NonNull Function<? super T, ? extends CharSequence> formatter) {
        if (formatter == null) {
            throw new NullPointerException("formatter is marked non-null but is null");
        }
        StringBuilder result = new StringBuilder();
        try {
            this.prettyPrintTo(result, maxLevel, formatter);
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
        return result.toString();
    }

    public void prettyPrintTo(@NonNull Appendable appendable, int maxLevel, @NonNull Function<? super T, ? extends CharSequence> formatter) throws IOException {
        if (appendable == null) {
            throw new NullPointerException("appendable is marked non-null but is null");
        }
        if (formatter == null) {
            throw new NullPointerException("formatter is marked non-null but is null");
        }
        appendable.append(formatter.apply(this.root)).append(System.lineSeparator());
        if (maxLevel > 0) {
            Iterator<T> i = this.children.apply(this.root).iterator();
            while (i.hasNext()) {
                this.prettyPrintTo(appendable, maxLevel - 1, formatter, i.next(), "", !i.hasNext());
            }
        }
    }

    private void prettyPrintTo(@NonNull Appendable appendable, int maxLevel, @NonNull Function<? super T, ? extends CharSequence> formatter, @NonNull T node, @NonNull String prefix, boolean last) throws IOException {
        if (appendable == null) {
            throw new NullPointerException("appendable is marked non-null but is null");
        }
        if (formatter == null) {
            throw new NullPointerException("formatter is marked non-null but is null");
        }
        if (node == null) {
            throw new NullPointerException("node is marked non-null but is null");
        }
        if (prefix == null) {
            throw new NullPointerException("prefix is marked non-null but is null");
        }
        appendable.append((CharSequence)prefix);
        if (last) {
            appendable.append("`-");
            prefix = (String)prefix + "   ";
        } else {
            appendable.append("|-");
            prefix = (String)prefix + "|  ";
        }
        appendable.append(formatter.apply(node)).append(System.lineSeparator());
        if (maxLevel > 0) {
            Iterator<T> i = this.children.apply(node).iterator();
            while (i.hasNext()) {
                this.prettyPrintTo(appendable, maxLevel - 1, formatter, i.next(), (String)prefix, !i.hasNext());
            }
        }
    }

    private static <T> LinkedList<T> newLinkedList(T item) {
        LinkedList<T> result = new LinkedList<T>();
        result.add(item);
        return result;
    }

    @Generated
    private TreeTraverser(@NonNull T root, @NonNull Function<? super T, ? extends Iterable<? extends T>> children) {
        if (root == null) {
            throw new NullPointerException("root is marked non-null but is null");
        }
        if (children == null) {
            throw new NullPointerException("children is marked non-null but is null");
        }
        this.root = root;
        this.children = children;
    }

    private static final class DepthFirstIterator<T>
    implements Iterator<T> {
        private final Deque<Iterator<? extends T>> stack;
        private final Function<? super T, ? extends Iterable<? extends T>> children;

        private DepthFirstIterator(T root, Function<? super T, ? extends Iterable<? extends T>> children) {
            this.stack = TreeTraverser.newLinkedList(Collections.singleton(root).iterator());
            this.children = children;
        }

        @Override
        public boolean hasNext() {
            return !this.stack.isEmpty() && this.stack.peek().hasNext();
        }

        @Override
        public T next() {
            Iterator<T> tmp;
            Iterator<T> top = this.stack.peek();
            T result = top.next();
            if (!top.hasNext()) {
                this.stack.pop();
            }
            if ((tmp = this.children.apply(result).iterator()).hasNext()) {
                this.stack.push(tmp);
            }
            return result;
        }
    }

    private static final class BreadthFirstIterator<T>
    implements Iterator<T> {
        private final Deque<T> queue;
        private final Function<? super T, ? extends Iterable<? extends T>> children;

        private BreadthFirstIterator(T root, Function<? super T, ? extends Iterable<? extends T>> children) {
            this.queue = TreeTraverser.newLinkedList(root);
            this.children = children;
        }

        @Override
        public boolean hasNext() {
            return !this.queue.isEmpty();
        }

        @Override
        public T next() {
            T result = this.queue.removeFirst();
            for (T o : this.children.apply(result)) {
                this.queue.addLast(o);
            }
            return result;
        }
    }
}

