/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.search.strategy.strategy;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import org.chocosolver.solver.ResolutionPolicy;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.search.loop.monitors.IMonitorRestart;
import org.chocosolver.solver.search.loop.monitors.IMonitorSolution;
import org.chocosolver.solver.search.restart.AbstractRestart;
import org.chocosolver.solver.search.strategy.assignments.DecisionOperatorFactory;
import org.chocosolver.solver.search.strategy.decision.Decision;
import org.chocosolver.solver.search.strategy.strategy.AbstractStrategy;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;

public class PartialAssignmentGenerator<V extends Variable>
extends AbstractStrategy<V>
implements IMonitorSolution,
IMonitorRestart {
    private final AbstractStrategy<V> mainStrategy;
    public final int[] lastSolution;
    public int lastObjective;
    public IntVar objectiveVariable;
    public final int varNum;
    public IntVar[] vars;
    public Solver solver;
    public LinkedList<Integer> objectiveValues;
    public LinkedList<int[]> solutionValues;
    private final boolean hackCutoff;
    public final int maxSolNum;
    public int recordSolNum;
    public final boolean isMaximize;
    public HashMap<String, Assignment> assignmentMap;
    public int lubyCutoffTimes;
    public boolean newSolutionFound;
    public int restartNum;
    public LinkedList<Assignment> paList;
    public LinkedList<Assignment> subtree;

    public PartialAssignmentGenerator(IntVar[] vs, int maxSN, boolean hackCutoff, AbstractStrategy<V> mainStrategy) {
        super((Variable[])vs);
        this.varNum = vs.length;
        this.vars = vs;
        this.solver = vs[0].getModel().getSolver();
        this.objectiveVariable = vs[0].getModel().getObjective().asIntVar();
        this.maxSolNum = maxSN;
        this.hackCutoff = hackCutoff;
        this.mainStrategy = mainStrategy;
        this.lastSolution = new int[this.varNum];
        this.solutionValues = new LinkedList();
        this.objectiveValues = new LinkedList();
        this.newSolutionFound = false;
        this.isMaximize = this.solver.getModel().getResolutionPolicy() == ResolutionPolicy.MAXIMIZE;
        this.assignmentMap = new HashMap();
        this.subtree = new LinkedList();
        this.lubyCutoffTimes = 1;
        this.restartNum = 1;
        this.recordSolNum = 0;
        this.paList = new LinkedList();
    }

    @Override
    public boolean init() {
        if (this.solver.getRestarter() == AbstractRestart.NO_RESTART) {
            throw new UnsupportedOperationException("Partial Assignment Generator requires a restart strategy. Please set a restart strategy. ");
        }
        this.solver.getRestarter().setGrower(() -> this.lubyCutoffTimes);
        if (!this.solver.getSearchMonitors().contains(this)) {
            this.solver.plugMonitor(this);
        }
        return this.mainStrategy.init();
    }

    @Override
    public void remove() {
        this.mainStrategy.remove();
        if (this.solver.getSearchMonitors().contains(this)) {
            this.solver.unplugMonitor(this);
        }
    }

    @Override
    public Decision<V> getDecision() {
        while (!this.subtree.isEmpty()) {
            Assignment as = this.subtree.removeFirst();
            int currentVar = as.varID;
            int currentVal = as.value;
            IntVar best = this.vars[currentVar];
            if (best.isInstantiated() || !best.contains(currentVal)) continue;
            return this.solver.getDecisionPath().makeIntDecision(best, DecisionOperatorFactory.makeIntEq(), currentVal);
        }
        return this.mainStrategy.getDecision();
    }

    @Override
    public void onSolution() {
        this.newSolutionFound = true;
        this.lastObjective = this.objectiveVariable.getValue();
        for (int i = 0; i < this.varNum; ++i) {
            this.lastSolution[i] = this.vars[i].getValue();
        }
    }

    public void generatePartialAssignment() {
        this.refinedGeneration();
    }

    private void generation() {
        this.paList.clear();
        Object sols = new int[][]{};
        sols = (int[][])this.solutionValues.toArray((T[])sols);
        double size = ((int[][])sols).length;
        int i = 0;
        while ((double)i < size - 1.0) {
            int[] sol1 = sols[i];
            int[] sol2 = sols[i + 1];
            ArrayList<Integer> list = this.compare(sol2, sol1);
            for (int k = 0; k < list.size(); k += 2) {
                int vid = list.get(k);
                int v = list.get(k + 1);
                Assignment as = new Assignment(this.vars[vid], vid, v);
                this.paList.add(as);
            }
            ++i;
        }
    }

    private void refinedGeneration() {
        this.paList.clear();
        this.assignmentMap.clear();
        int[] objs = new int[this.objectiveValues.size()];
        int index = 0;
        Iterator ite = this.objectiveValues.iterator();
        while (ite.hasNext()) {
            objs[index++] = (Integer)ite.next();
        }
        Object sols = new int[][]{};
        sols = (int[][])this.solutionValues.toArray((T[])sols);
        int range = ((int[][])sols).length / 2;
        for (int i = 0; i < range; ++i) {
            int[] sol1 = sols[i];
            double decayWeight = (double)(range - i) * 1.0 / (double)range;
            for (int j = 0; j < range; ++j) {
                int[] sol2 = sols[j + i + 1];
                ArrayList<Integer> list = this.compare(sol2, sol1);
                double score = objs[i] - objs[j];
                if (!this.isMaximize) {
                    score = 0.0 - score;
                }
                score *= decayWeight;
                double upNum = (double)list.size() / 2.0;
                score /= upNum;
                for (int k = 0; k < list.size(); k += 2) {
                    Assignment as;
                    int v;
                    int vid = list.get(k);
                    String name = Assignment.getName(vid, v = list.get(k + 1).intValue());
                    if (this.assignmentMap.containsKey(name)) {
                        as = this.assignmentMap.get(name);
                        as.increScore(score);
                        continue;
                    }
                    as = new Assignment(this.vars[vid], vid, v);
                    as.increScore(score);
                    this.assignmentMap.put(name, as);
                }
            }
        }
        this.paList.addAll(this.assignmentMap.values());
        Assignment[] asArray = new Assignment[this.paList.size()];
        asArray = this.paList.toArray(asArray);
        Arrays.sort(asArray, Comparator.comparingDouble(Assignment::getAveScore));
        this.paList.clear();
        for (int i = asArray.length - 1; i >= 0; --i) {
            this.paList.addLast(asArray[i]);
        }
    }

    @Override
    public void beforeRestart() {
        this.lubyCutoffTimes = 1;
        ++this.restartNum;
        if (!this.paList.isEmpty()) {
            this.subtree.clear();
            this.subtree.addAll(this.paList);
            int n = this.paList.size() / 2;
            if (n == 0) {
                n = 1;
            }
            while (n > 0 && !this.paList.isEmpty()) {
                this.paList.removeLast();
                --n;
            }
        }
        if (this.newSolutionFound) {
            this.newSolutionFound = false;
            if (this.solutionValues.size() == this.maxSolNum) {
                this.solutionValues.removeLast();
                this.objectiveValues.removeLast();
            }
            this.solutionValues.addFirst((int[])this.lastSolution.clone());
            ++this.recordSolNum;
            this.objectiveValues.addFirst(this.lastObjective);
            if (this.objectiveValues.size() > 1) {
                this.generatePartialAssignment();
                this.subtree.clear();
                this.subtree.addAll(this.paList);
                this.lubyCutoffTimes = this.hackCutoff ? this.restartNum : 1;
            }
            this.restartNum = 1;
        }
    }

    public ArrayList<Integer> compare(int[] worseSol, int[] betterSol) {
        ArrayList<Integer> results = new ArrayList<Integer>();
        for (int i = 0; i < this.varNum; ++i) {
            int v1 = worseSol[i];
            int v2 = betterSol[i];
            if (v1 == v2) continue;
            results.add(i);
            results.add(v2);
        }
        return results;
    }

    public static class Assignment {
        public String name;
        public IntVar var;
        public int value;
        public double score;
        public int varID;
        public double incTimes;

        public Assignment(IntVar vr, int vid, int v) {
            this.varID = vid;
            this.var = vr;
            this.value = v;
            this.name = Assignment.getName(vid, v);
            this.score = 0.0;
            this.incTimes = 0.0;
        }

        public static String getName(int vid, int v) {
            return "X[" + vid + "]=" + v;
        }

        public void increScore(double d) {
            this.score += d;
            this.incTimes += 1.0;
        }

        public double getAveScore() {
            return this.score / this.incTimes;
        }

        public void print() {
            System.out.print("(" + this.name + ", " + this.score + ") || ");
        }
    }
}

