/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.model;

import dr.inference.model.Bounds;
import dr.inference.model.IntersectionBounds;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.inference.model.VariableListener;
import java.util.ArrayList;
import java.util.List;

public class CompoundParameter
extends Parameter.Abstract
implements VariableListener {
    protected final List<Parameter> uniqueParameters = new ArrayList<Parameter>();
    private final ArrayList<Parameter> parameters = new ArrayList();
    private final ArrayList<Integer> pIndex = new ArrayList();
    private Bounds<Double> bounds = null;
    private int dimension;
    private String name;
    protected boolean doNotPropagateChangeUp = false;

    public CompoundParameter(String string, Parameter[] parameterArray) {
        this(string);
        for (Parameter parameter : parameterArray) {
            this.dimension += parameter.getDimension();
            parameter.addParameterListener(this);
        }
        for (Parameter parameter : parameterArray) {
            for (int i = 0; i < parameter.getDimension(); ++i) {
                this.parameters.add(parameter);
                this.pIndex.add(i);
            }
            this.uniqueParameters.add(parameter);
            this.labelParameter(parameter);
        }
    }

    public CompoundParameter(String string) {
        this.name = string;
        this.dimension = 0;
    }

    private void labelParameter(Parameter parameter) {
        if (parameter.getParameterName() == null) {
            String string = this.name + this.uniqueParameters.size();
            parameter.setId(string);
        }
    }

    public void addParameter(Parameter parameter) {
        this.uniqueParameters.add(parameter);
        for (int i = 0; i < parameter.getDimension(); ++i) {
            this.parameters.add(parameter);
            this.pIndex.add(i);
        }
        this.dimension += parameter.getDimension();
        if (this.dimension != this.parameters.size()) {
            throw new RuntimeException("dimension=" + this.dimension + " parameters.size()=" + this.parameters.size());
        }
        parameter.addParameterListener(this);
        this.labelParameter(parameter);
    }

    public void removeParameter(Parameter parameter) {
        int n = 0;
        for (Parameter parameter2 : this.uniqueParameters) {
            if (parameter2 == parameter) break;
            n += parameter2.getDimension();
        }
        for (int i = 0; i < parameter.getDimension(); ++i) {
            this.parameters.remove(n);
            this.pIndex.remove(n);
        }
        if (this.parameters.contains(parameter)) {
            throw new RuntimeException();
        }
        this.uniqueParameters.remove(parameter);
        this.dimension -= parameter.getDimension();
        if (this.dimension != this.parameters.size()) {
            throw new RuntimeException();
        }
        parameter.removeParameterListener(this);
    }

    @Override
    public final String getParameterName() {
        if (this.name != null) {
            return this.name;
        }
        return this.getId();
    }

    public Parameter getParameter(int n) {
        return this.uniqueParameters.get(n);
    }

    public int getParameterCount() {
        return this.uniqueParameters.size();
    }

    @Override
    public String getDimensionName(int n) {
        return this.parameters.get(n).getDimensionName(this.pIndex.get(n));
    }

    @Override
    public int getDimension() {
        return this.dimension;
    }

    @Override
    public void setDimension(int n) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addBounds(Bounds<Double> bounds) {
        if (this.bounds == null) {
            this.bounds = new CompoundBounds();
        }
        IntersectionBounds intersectionBounds = new IntersectionBounds(this.getDimension());
        intersectionBounds.addBounds(this.bounds);
        intersectionBounds.addBounds(bounds);
        this.bounds = intersectionBounds;
    }

    @Override
    public Bounds<Double> getBounds() {
        if (this.bounds == null) {
            this.bounds = new CompoundBounds();
        }
        return this.bounds;
    }

    @Override
    public void addDimension(int n, double d) {
        Parameter parameter = this.parameters.get(n);
        int n2 = this.pIndex.get(n);
        this.parameters.add(n, parameter);
        this.pIndex.add(n, n2);
        parameter.addDimension(n2, d);
        for (int i = n2; i < parameter.getDimension(); ++i) {
            this.pIndex.set(n, i);
            ++n;
        }
    }

    @Override
    public double removeDimension(int n) {
        Parameter parameter = this.parameters.get(n);
        int n2 = this.pIndex.get(n);
        this.parameters.remove(n);
        this.pIndex.remove(n);
        double d = parameter.removeDimension(n2);
        for (int i = n2; i < parameter.getDimension(); ++i) {
            this.pIndex.set(n, i);
            ++n;
        }
        return d;
    }

    @Override
    public void fireParameterChangedEvent() {
        this.doNotPropagateChangeUp = true;
        for (Parameter parameter : this.parameters) {
            parameter.fireParameterChangedEvent();
        }
        this.doNotPropagateChangeUp = false;
        this.fireParameterChangedEvent(-1, Variable.ChangeType.ALL_VALUES_CHANGED);
    }

    @Override
    public double getParameterValue(int n) {
        return this.parameters.get(n).getParameterValue(this.pIndex.get(n));
    }

    @Override
    public void setParameterValue(int n, double d) {
        this.parameters.get(n).setParameterValue(this.pIndex.get(n), d);
    }

    @Override
    public void setParameterValueQuietly(int n, double d) {
        this.parameters.get(n).setParameterValueQuietly(this.pIndex.get(n), d);
    }

    @Override
    public void setParameterValueNotifyChangedAll(int n, double d) {
        this.parameters.get(n).setParameterValueNotifyChangedAll(this.pIndex.get(n), d);
    }

    @Override
    protected void storeValues() {
        for (Parameter parameter : this.uniqueParameters) {
            parameter.storeParameterValues();
        }
    }

    @Override
    protected void restoreValues() {
        for (Parameter parameter : this.uniqueParameters) {
            parameter.restoreParameterValues();
        }
    }

    @Override
    protected void acceptValues() {
        for (Parameter parameter : this.uniqueParameters) {
            parameter.acceptParameterValues();
        }
    }

    @Override
    protected final void adoptValues(Parameter parameter) {
    }

    @Override
    public String toString() {
        return this.toStringCompoundParameter(this.getDimension());
    }

    protected String toStringCompoundParameter(int n) {
        StringBuilder stringBuilder = new StringBuilder(String.valueOf(this.getParameterValue(0)));
        Bounds<Double> bounds = this.getBounds();
        stringBuilder.append("[").append(String.valueOf(bounds.getLowerLimit(0)));
        stringBuilder.append(",").append(String.valueOf(bounds.getUpperLimit(0))).append("]");
        for (int i = 1; i < n; ++i) {
            stringBuilder.append(", ").append(String.valueOf(this.getParameterValue(i)));
            stringBuilder.append("[").append(String.valueOf(bounds.getLowerLimit(i)));
            stringBuilder.append(",").append(String.valueOf(bounds.getUpperLimit(i))).append("]");
        }
        return stringBuilder.toString();
    }

    @Override
    public void variableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        int n2 = 0;
        if (!this.doNotPropagateChangeUp) {
            for (Parameter parameter : this.uniqueParameters) {
                if (variable == parameter) {
                    int n3 = n == -1 ? -1 : n2 + n;
                    this.fireParameterChangedEvent(n3, changeType);
                    break;
                }
                n2 += parameter.getDimension();
            }
        }
    }

    public double getParameterValue(int n, int n2) {
        return this.getParameter(n2).getParameterValue(n);
    }

    public static CompoundParameter mergeParameters(String string, CompoundParameter[] compoundParameterArray, Boolean bl) {
        int n = compoundParameterArray[0].getParameterCount();
        for (int i = 1; i < compoundParameterArray.length; ++i) {
            assert (n == compoundParameterArray[i].getParameterCount());
        }
        CompoundParameter compoundParameter = new CompoundParameter(string);
        for (int i = 0; i < n; ++i) {
            String string2 = compoundParameterArray[0].getParameter(i).getParameterName();
            CompoundParameter compoundParameter2 = new CompoundParameter(string2);
            for (int j = 0; j < compoundParameterArray.length; ++j) {
                Parameter parameter = compoundParameterArray[j].getParameter(i);
                if (bl.booleanValue() && parameter.getParameterName() != string2) {
                    throw new RuntimeException("parameter " + j + " with sub-parameter " + i + " has name " + parameter.getParameterName() + ". This does not match parameter 0 with sub-parameter " + i + " that has name " + string2 + ".");
                }
                compoundParameter2.addParameter(parameter);
            }
            compoundParameter.addParameter(compoundParameter2);
        }
        return compoundParameter;
    }

    public static CompoundParameter mergeParameters(CompoundParameter[] compoundParameterArray) {
        String string = compoundParameterArray[0].getParameterName();
        for (int i = 1; i < compoundParameterArray.length; ++i) {
            string = string + "_and_" + compoundParameterArray[i].getParameterName();
        }
        return CompoundParameter.mergeParameters(string, compoundParameterArray, true);
    }

    public static void checkParametersMerged(CompoundParameter compoundParameter, CompoundParameter[] compoundParameterArray) {
        int n = compoundParameter.getParameterCount();
        for (int i = 0; i < n; ++i) {
            int n2;
            CompoundParameter compoundParameter2 = (CompoundParameter)compoundParameter.getParameter(i);
            for (n2 = 0; n2 < compoundParameterArray.length; ++n2) {
                assert (compoundParameter2.getParameter(n2) == compoundParameterArray[n2].getParameter(i));
            }
            n2 = 0;
            int n3 = 0;
            int n4 = compoundParameterArray[n2].getParameter(i).getDimension();
            for (int j = 0; j < compoundParameter2.getDimension(); ++j) {
                if (n3 == n4) {
                    n3 = 0;
                    n4 = compoundParameterArray[++n2].getParameter(i).getDimension();
                }
                double d = compoundParameter2.getParameterValue(j);
                double d2 = compoundParameterArray[n2].getParameter(i).getParameterValue(n3);
                assert (d == d2);
                ++n3;
            }
        }
    }

    protected ArrayList<Parameter> getParameters() {
        return this.parameters;
    }

    public static void main(String[] stringArray) {
        Parameter.Default default_ = new Parameter.Default(2);
        Parameter.Default default_2 = new Parameter.Default(2);
        Parameter.Default default_3 = new Parameter.Default(2);
        System.out.println(default_.getDimension());
        CompoundParameter compoundParameter = new CompoundParameter("parameter", new Parameter[]{default_, default_2});
        compoundParameter.addParameter(default_3);
        compoundParameter.removeParameter(default_2);
    }

    private class CompoundBounds
    implements Bounds<Double> {
        private CompoundBounds() {
        }

        @Override
        public Double getUpperLimit(int n) {
            return ((Parameter)CompoundParameter.this.parameters.get(n)).getBounds().getUpperLimit((Integer)CompoundParameter.this.pIndex.get(n));
        }

        @Override
        public Double getLowerLimit(int n) {
            return ((Parameter)CompoundParameter.this.parameters.get(n)).getBounds().getLowerLimit((Integer)CompoundParameter.this.pIndex.get(n));
        }

        @Override
        public int getBoundsDimension() {
            return CompoundParameter.this.getDimension();
        }
    }
}

