/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.coalescent.basta;

import dr.evomodel.treedatalikelihood.continuous.cdi.ResourceDetails;

public class NativeBastaJniWrapper {
    private static final String LIBRARY_NAME = NativeBastaJniWrapper.getPlatformSpecificLibraryName();
    private static NativeBastaJniWrapper INSTANCE;

    private NativeBastaJniWrapper() {
    }

    public native void functionOne();

    public native void functionTwo();

    public native String getVersion();

    public native String getCitation();

    public native ResourceDetails[] getResourceList();

    public static NativeBastaJniWrapper getBastaJniWrapper() {
        if (INSTANCE == null) {
            try {
                NativeBastaJniWrapper.loadBastaLibrary();
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                System.err.println("Failed to load native BASTA library: " + unsatisfiedLinkError.getMessage());
            }
        }
        return INSTANCE;
    }

    private static String getPlatformSpecificLibraryName() {
        String string = System.getProperty("os.name").toLowerCase();
        String string2 = System.getProperty("os.arch").toLowerCase();
        if (string.startsWith("windows")) {
            if (string2.equals("x86") || string2.equals("i386")) {
                return "native_basta32";
            }
            if (string2.startsWith("amd64") || string2.startsWith("x86_64")) {
                return "native_basta64";
            }
        }
        return "native_basta-jni";
    }

    private static void loadBastaLibrary() throws UnsatisfiedLinkError {
        String string = "";
        if (System.getProperty("basta.library.path") != null && (string = System.getProperty("basta.library.path")).length() > 0 && !string.endsWith("/")) {
            string = string + "/";
        }
        System.loadLibrary(string + LIBRARY_NAME);
        INSTANCE = new NativeBastaJniWrapper();
    }
}

